"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorDataGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_PAGE_SIZE = 15;
const InspectorDataGrid = ({
  columns,
  data,
  dataGridAriaLabel
}) => {
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: DEFAULT_PAGE_SIZE
  });
  const onChangeItemsPerPage = (0, _react.useCallback)(pageSize => setPagination(p => ({
    ...p,
    pageSize,
    pageIndex: 0
  })), [setPagination]);
  const onChangePage = (0, _react.useCallback)(pageIndex => setPagination(p => ({
    ...p,
    pageIndex
  })), [setPagination]);

  // Column visibility
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    setPagination({
      ...pagination,
      pageIndex: 0
    });
    setVisibleColumns(columns.map(column => column.id));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dataGridAriaLabel]);

  // Sorting
  const [sortingColumns, setSortingColumns] = (0, _react.useState)([]);
  const onSort = (0, _react.useCallback)(newSortingColumns => {
    setSortingColumns(newSortingColumns);
  }, [setSortingColumns]);
  let gridData = (0, _react.useMemo)(() => {
    return [...data].sort((a, b) => {
      for (let i = 0; i < sortingColumns.length; i++) {
        const column = sortingColumns[i];
        const aValue = a[column.id];
        const bValue = b[column.id];
        if (aValue < bValue) return column.direction === 'asc' ? -1 : 1;
        if (aValue > bValue) return column.direction === 'asc' ? 1 : -1;
      }
      return 0;
    });
  }, [data, sortingColumns]);
  const renderCellValue = (0, _react.useMemo)(() => {
    return ({
      rowIndex,
      columnId
    }) => {
      let adjustedRowIndex = rowIndex;

      // If we are doing the pagination (instead of leaving that to the grid)
      // then the row index must be adjusted as `data` has already been pruned to the page size
      adjustedRowIndex = rowIndex - pagination.pageIndex * pagination.pageSize;
      return gridData.hasOwnProperty(adjustedRowIndex) ? gridData[adjustedRowIndex][columnId] || null : null;
    };
  }, [gridData, pagination.pageIndex, pagination.pageSize]);

  // Pagination
  gridData = (0, _react.useMemo)(() => {
    const rowStart = pagination.pageIndex * pagination.pageSize;
    const rowEnd = Math.min(rowStart + pagination.pageSize, gridData.length);
    return gridData.slice(rowStart, rowEnd);
  }, [gridData, pagination]);

  // Resize
  const [columnsWidth, setColumnsWidth] = (0, _react.useState)({});
  const onColumnResize = (0, _react.useCallback)(({
    columnId,
    width
  }) => {
    setColumnsWidth({
      ...columnsWidth,
      [columnId]: width
    });
  }, [columnsWidth]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": dataGridAriaLabel,
    columns: columns.map(column => {
      if (columnsWidth[column.id]) {
        return {
          ...column,
          initialWidth: columnsWidth[column.id]
        };
      }
      return column;
    }),
    columnVisibility: {
      visibleColumns,
      setVisibleColumns
    },
    rowCount: data.length,
    renderCellValue: renderCellValue,
    sorting: {
      columns: sortingColumns,
      onSort
    },
    toolbarVisibility: {
      showFullScreenSelector: false
    },
    onColumnResize: onColumnResize,
    pagination: {
      ...pagination,
      pageSizeOptions: [DEFAULT_PAGE_SIZE, 25, 50],
      onChangeItemsPerPage,
      onChangePage
    }
  });
};
exports.InspectorDataGrid = InspectorDataGrid;