"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VegaVisComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _vega_visualization = require("../vega_visualization");
var _vega_vis = require("./vega_vis.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const THROTTLE_INTERVAL = 300;
const VegaVisComponent = ({
  visData,
  fireEvent,
  renderComplete,
  deps,
  renderMode
}) => {
  const chartDiv = (0, _react.useRef)(null);
  const renderCompleted = (0, _react.useRef)(false);
  const visController = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (chartDiv.current) {
      const VegaVis = (0, _vega_visualization.createVegaVisualization)(deps, renderMode);
      visController.current = new VegaVis(chartDiv.current, fireEvent);
    }
    return () => {
      var _visController$curren;
      (_visController$curren = visController.current) === null || _visController$curren === void 0 ? void 0 : _visController$curren.destroy();
      visController.current = null;
    };
  }, [deps, fireEvent, renderMode]);
  (0, _react.useEffect)(() => {
    const asyncRender = async visCtrl => {
      await visCtrl.render(visData);
      renderCompleted.current = true;
      renderComplete();
    };
    if (visController.current) {
      asyncRender(visController.current);
    }
  }, [renderComplete, visData]);
  const resizeChart = (0, _react.useMemo)(() => (0, _lodash.throttle)(dimensions => {
    var _visController$curren2;
    (_visController$curren2 = visController.current) === null || _visController$curren2 === void 0 ? void 0 : _visController$curren2.resize(dimensions);
  }, THROTTLE_INTERVAL, {
    leading: false,
    trailing: true
  }), []);
  const onContainerResize = (0, _react.useCallback)(dimensions => {
    if (renderCompleted.current) {
      resizeChart(dimensions);
    }
  }, [resizeChart]);
  const euiTheme = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_vega_vis.GlobalVegaVisStyles, null), /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onContainerResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    className: "vgaVis__wrapper",
    css: (0, _vega_vis.wrapperStyles)(euiTheme),
    ref: resizeRef
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: chartDiv
  }))));
};
exports.VegaVisComponent = VegaVisComponent;