"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsRequestHandler = void 0;
var _visualizationUtils = require("@kbn/visualization-utils");
var _services = require("./services");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const metricsRequestHandler = async ({
  input,
  uiState,
  visParams,
  searchSessionId,
  executionContext,
  inspectorAdapters,
  expressionAbortSignal
}) => {
  if (!expressionAbortSignal.aborted) {
    var _uiState$visParams$ty;
    const config = (0, _services.getUISettings)();
    const data = (0, _services.getDataStart)();
    const abortController = new AbortController();
    const expressionAbortHandler = function () {
      abortController.abort();
    };
    expressionAbortSignal.addEventListener('abort', expressionAbortHandler);
    const timezone = (0, _visualizationUtils.getTimeZone)(config);
    const uiStateObj = (_uiState$visParams$ty = uiState[visParams.type]) !== null && _uiState$visParams$ty !== void 0 ? _uiState$visParams$ty : {};
    const dataSearch = data.search;
    const parsedTimeRange = data.query.timefilter.timefilter.calculateBounds(input === null || input === void 0 ? void 0 : input.timeRange);
    const doSearch = async searchOptions => {
      return await (0, _services.getCoreStart)().http.post(_constants.ROUTES.VIS_DATA, {
        body: JSON.stringify({
          timerange: {
            timezone,
            ...parsedTimeRange
          },
          query: input === null || input === void 0 ? void 0 : input.query,
          filters: input === null || input === void 0 ? void 0 : input.filters,
          panels: [visParams],
          state: uiStateObj,
          ...(searchOptions ? {
            searchSession: searchOptions
          } : {})
        }),
        context: executionContext,
        signal: abortController.signal
      });
    };
    if (visParams && visParams.id && !visParams.isModelInvalid && !expressionAbortSignal.aborted) {
      const searchTracker = dataSearch.session.isCurrentSession(searchSessionId) ? dataSearch.session.trackSearch({
        abort: () => abortController.abort(),
        poll: async () => {
          // don't use, keep this empty, onSavingSession is used instead
        },
        onSavingSession: async searchSessionOptions => {
          await doSearch(searchSessionOptions);
        }
      }) : undefined;
      try {
        var _inspectorAdapters$re;
        const searchSessionOptions = dataSearch.session.getSearchOptions(searchSessionId);
        const visData = await doSearch(searchSessionOptions);
        inspectorAdapters === null || inspectorAdapters === void 0 ? void 0 : (_inspectorAdapters$re = inspectorAdapters.requests) === null || _inspectorAdapters$re === void 0 ? void 0 : _inspectorAdapters$re.reset();
        Object.entries(visData.trackedEsSearches || {}).forEach(([key, query]) => {
          var _inspectorAdapters$re2, _query$label;
          inspectorAdapters === null || inspectorAdapters === void 0 ? void 0 : (_inspectorAdapters$re2 = inspectorAdapters.requests) === null || _inspectorAdapters$re2 === void 0 ? void 0 : _inspectorAdapters$re2.start((_query$label = query.label) !== null && _query$label !== void 0 ? _query$label : key, {
            searchSessionId
          }).json(query.body).ok({
            time: query.time,
            json: {
              rawResponse: query.response
            }
          });
        });
        searchTracker === null || searchTracker === void 0 ? void 0 : searchTracker.complete();
        return visData;
      } catch (e) {
        searchTracker === null || searchTracker === void 0 ? void 0 : searchTracker.error();
        throw e;
      } finally {
        expressionAbortSignal.removeEventListener('abort', expressionAbortHandler);
      }
    }
  }
  return {};
};
exports.metricsRequestHandler = metricsRequestHandler;