"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPercentileRanksColumnWithMeta = exports.convertToPercentileRankParams = exports.convertToPercentileRankColumns = exports.convertToPercentileRankColumn = void 0;
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _column = require("./column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isPercentileRanksColumnWithMeta = column => {
  var _meta;
  return column.operationType === _convert_to_lens.Operations.PERCENTILE_RANK && Boolean((_meta = column.meta) === null || _meta === void 0 ? void 0 : _meta.reference);
};
exports.isPercentileRanksColumnWithMeta = isPercentileRanksColumnWithMeta;
const convertToPercentileRankParams = value => value !== undefined && !isNaN(Number(value)) ? {
  value: Number(value)
} : null;
exports.convertToPercentileRankParams = convertToPercentileRankParams;
const convertToPercentileRankColumn = (value, series, metric, dataView, {
  index,
  reducedTimeRange,
  timeShift
} = {}) => {
  var _metric$field;
  const params = convertToPercentileRankParams(value);
  if (!params) {
    return null;
  }
  const field = dataView.getFieldByName((_metric$field = metric.field) !== null && _metric$field !== void 0 ? _metric$field : 'document');
  if (!field) {
    return null;
  }
  const commonColumnParams = (0, _column.createColumn)(series, metric, field, {
    reducedTimeRange,
    timeShift
  });
  const meta = index !== undefined ? {
    reference: `${metric.id}.${index}`,
    ...commonColumnParams.meta
  } : commonColumnParams.meta;
  return {
    operationType: 'percentile_rank',
    sourceField: field.name,
    ...commonColumnParams,
    params: {
      ...params,
      ...(0, _column.getFormat)(series)
    },
    meta
  };
};
exports.convertToPercentileRankColumn = convertToPercentileRankColumn;
const convertToPercentileRankColumns = ({
  series,
  metric,
  dataView
}, additionalArgs) => {
  const {
    values
  } = metric;
  if (!values) {
    return null;
  }
  return values.map((p, index) => convertToPercentileRankColumn(p, series, metric, dataView, {
    index,
    ...additionalArgs
  }));
};
exports.convertToPercentileRankColumns = convertToPercentileRankColumns;