"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnState = void 0;
var _palette = require("../palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getColumnState = (columnId, collapseFn, series) => {
  var _series$color_rules;
  const palette = series ? (0, _palette.getPalette)((_series$color_rules = series.color_rules) !== null && _series$color_rules !== void 0 ? _series$color_rules : []) : undefined;
  return {
    columnId,
    alignment: 'left',
    colorMode: palette ? 'text' : 'none',
    ...(palette ? {
      palette
    } : {}),
    ...(collapseFn ? {
      collapseFn
    } : {})
  };
};
exports.getColumnState = getColumnState;