"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visWithSplits = visWithSplits;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _get_display_name = require("./lib/get_display_name");
var _lodash = require("lodash");
var _empty_label = require("../../../common/empty_label");
var _get_split_by_terms_color = require("../lib/get_split_by_terms_color");
var _constants = require("../../../common/constants");
require("./_vis_with_splits.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function visWithSplits(WrappedComponent) {
  function SplitVisComponent(props) {
    const {
      model,
      visData,
      syncColors,
      palettesService,
      fieldFormatMap
    } = props;
    const getSeriesColor = (0, _react.useCallback)((seriesName, seriesId, baseColor) => {
      const palette = {
        ...model.series[0].palette,
        name: model.series[0].split_color_mode === 'kibana' ? 'kibana_palette' : model.series[0].split_color_mode || model.series[0].palette.name
      };
      const props = {
        seriesById: visData[model.id].series,
        seriesName,
        seriesId,
        baseColor,
        seriesPalette: palette,
        palettesRegistry: palettesService,
        syncColors,
        fieldFormatMap
      };
      return (0, _get_split_by_terms_color.getSplitByTermsColor)(props) || null;
    }, [fieldFormatMap, model.id, model.series, palettesService, syncColors, visData]);
    if (!model || !visData || !visData[model.id]) return /*#__PURE__*/_react.default.createElement(WrappedComponent, props);
    if (visData[model.id].series.every(s => s.id.split(_constants.SERIES_SEPARATOR).length === 1)) {
      return /*#__PURE__*/_react.default.createElement(WrappedComponent, props);
    }
    const splitsVisData = visData[model.id].series.reduce((acc, series) => {
      const [seriesId, splitId] = series.id.split(_constants.SERIES_SEPARATOR);
      const seriesModel = model.series.find(s => s.id === seriesId);
      if (!seriesModel) return acc;
      const label = series.splitByLabel;
      if (!acc[splitId]) {
        acc[splitId] = {
          series: [],
          label: series.label.toString()
        };
      }
      const labelHasKeyPlaceholder = /{{\s*key\s*}}/.test(seriesModel.label);
      const color = series.color || seriesModel.color;
      const finalColor = model.series[0].split_mode === 'terms' ? getSeriesColor(label, series.id, color) : color;
      acc[splitId].series.push({
        ...series,
        id: seriesId,
        color: finalColor,
        label: seriesModel.label && !labelHasKeyPlaceholder ? seriesModel.label : label
      });
      return acc;
    }, {});
    const nonSplitSeries = (0, _lodash.first)(visData[model.id].series.filter(series => {
      const seriesModel = model.series.find(s => s.id === series.id);
      if (!seriesModel) return false;
      return ['everything', 'filter'].includes(seriesModel.split_mode);
    }));
    const indexOfNonSplit = nonSplitSeries ? (0, _lodash.findIndex)(model.series, s => s.id === nonSplitSeries.id) : null;
    const rows = Object.keys(splitsVisData).map((key, index, arrayRef) => {
      const splitData = splitsVisData[key];
      const {
        series,
        label
      } = splitData;
      const additionalLabel = label;
      const newSeries = indexOfNonSplit != null && indexOfNonSplit > 0 ? [...series, nonSplitSeries] : [nonSplitSeries, ...series];
      const newVisData = {
        [model.id]: {
          id: model.id,
          series: newSeries || series
        }
      };
      return /*#__PURE__*/_react.default.createElement("div", {
        key: key,
        className: "tvbSplitVis__split"
      }, /*#__PURE__*/_react.default.createElement(WrappedComponent, {
        model: model,
        visData: newVisData,
        onBrush: props.onBrush,
        onFilterClick: props.onFilterClick,
        additionalLabel: (0, _empty_label.getValueOrEmpty)(additionalLabel),
        backgroundColor: props.backgroundColor,
        getConfig: props.getConfig,
        fieldFormatMap: props.fieldFormatMap,
        initialRender: arrayRef.length - 1 === index ? props.initialRender : undefined
      }));
    });
    const hasOneVis = visData[model.id].series.length === 1;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('tvbSplitVis', {
        'tvbSplitVis--one': hasOneVis
      })
    }, rows);
  }
  SplitVisComponent.displayName = `SplitVisComponent(${(0, _get_display_name.getDisplayName)(WrappedComponent)})`;
  return SplitVisComponent;
}