"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitByTermsUI = exports.SplitByTerms = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _group_by_select = require("./group_by_select");
var _create_text_handler = require("../lib/create_text_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _stacked = require("../lib/stacked");
var _field_select = require("../aggs/field_select");
var _metric_select = require("../aggs/metric_select");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _constants = require("../../visualizations/constants");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULTS = {
  terms_direction: 'desc',
  terms_size: 10,
  terms_order_by: '_count'
};
const RESET_STATE = {
  terms_field: undefined,
  terms_include: undefined,
  terms_exclude: undefined,
  terms_direction: undefined,
  terms_size: undefined,
  terms_order_by: undefined
};
const SplitByTermsUI = ({
  onChange,
  indexPattern,
  intl,
  model: seriesModel,
  fields,
  uiRestrictions,
  seriesQuantity
}) => {
  var _model$terms_include, _model$terms_exclude;
  const htmlId = (0, _eui.htmlIdGenerator)();
  const handleTextChange = (0, _create_text_handler.createTextHandler)(onChange);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(onChange);
  const model = {
    ...DEFAULTS,
    ...seriesModel
  };
  const {
    metrics
  } = model;
  const defaultCount = {
    value: '_count',
    label: intl.formatMessage({
      id: 'visTypeTimeseries.splits.terms.defaultCountLabel',
      defaultMessage: 'Doc Count (default)'
    })
  };
  const terms = {
    value: '_key',
    label: intl.formatMessage({
      id: 'visTypeTimeseries.splits.terms.termsLabel',
      defaultMessage: 'Terms'
    })
  };
  const dirOptions = [{
    value: 'desc',
    label: intl.formatMessage({
      id: 'visTypeTimeseries.splits.terms.dirOptions.descendingLabel',
      defaultMessage: 'Descending'
    })
  }, {
    value: 'asc',
    label: intl.formatMessage({
      id: 'visTypeTimeseries.splits.terms.dirOptions.ascendingLabel',
      defaultMessage: 'Ascending'
    })
  }];
  const fieldsSelector = (0, _index_patterns_utils.getIndexPatternKey)(indexPattern);
  const selectedDirectionOption = dirOptions.find(option => {
    return model.terms_direction === option.value;
  });
  const selectedField = (0, _lodash.find)(fields[fieldsSelector], ({
    name
  }) => name === model.terms_field);
  const selectedFieldType = (0, _lodash.get)(selectedField, 'type');
  const onTermsFieldChange = (0, _react.useCallback)(selectedOptions => {
    onChange({
      terms_field: selectedOptions.length === 1 ? selectedOptions[0] : selectedOptions,
      terms_include: undefined,
      terms_exclude: undefined
    });
  }, [onChange]);
  if (seriesQuantity && model.stacked === _constants.STACKED_OPTIONS.PERCENT && (0, _stacked.isPercentDisabled)(seriesQuantity[model.id])) {
    onChange({
      ['stacked']: _constants.STACKED_OPTIONS.NONE
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('group'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.terms.groupByLabel",
      defaultMessage: "Group by"
    })
  }, /*#__PURE__*/_react.default.createElement(_group_by_select.GroupBySelect, {
    value: model.split_mode,
    onChange: ([{
      value: newSplitMode = null
    }]) => {
      onChange({
        split_mode: newSplitMode,
        ...RESET_STATE
      });
    },
    uiRestrictions: uiRestrictions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.terms.byLabel",
      defaultMessage: "By",
      description: "This labels a field selector allowing the user to chose 'by' which field to group."
    }),
    restrict: [_public.KBN_FIELD_TYPES.NUMBER, _public.KBN_FIELD_TYPES.BOOLEAN, _public.KBN_FIELD_TYPES.DATE, _public.KBN_FIELD_TYPES.IP, _public.KBN_FIELD_TYPES.STRING],
    "data-test-subj": "groupByField",
    indexPattern: indexPattern,
    onChange: onTermsFieldChange,
    value: model.terms_field,
    fields: fields,
    uiRestrictions: uiRestrictions,
    type: 'terms',
    allowMultiSelect: true
  }))), selectedFieldType === _public.KBN_FIELD_TYPES.STRING && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('include'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.terms.includeLabel",
      defaultMessage: "Include"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: (_model$terms_include = model.terms_include) !== null && _model$terms_include !== void 0 ? _model$terms_include : '',
    onChange: handleTextChange('terms_include'),
    "data-test-subj": "groupByInclude"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('exclude'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.terms.excludeLabel",
      defaultMessage: "Exclude"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: (_model$terms_exclude = model.terms_exclude) !== null && _model$terms_exclude !== void 0 ? _model$terms_exclude : '',
    onChange: handleTextChange('terms_exclude'),
    "data-test-subj": "groupByExclude"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('top'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.terms.topLabel",
      defaultMessage: "Top"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    placeholder: intl.formatMessage({
      id: 'visTypeTimeseries.splits.terms.sizePlaceholder',
      defaultMessage: 'Size'
    }),
    value: Number(model.terms_size),
    onChange: handleTextChange('terms_size')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('order'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.terms.orderByLabel",
      defaultMessage: "Order by"
    })
  }, /*#__PURE__*/_react.default.createElement(_metric_select.MetricSelect, {
    metrics: metrics,
    clearable: false,
    additionalOptions: [defaultCount, terms],
    fields: fields[fieldsSelector],
    onChange: handleSelectChange('terms_order_by'),
    restrict: "basic",
    value: model.terms_order_by
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('direction'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.terms.directionLabel",
      defaultMessage: "Direction"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: false,
    options: dirOptions,
    selectedOptions: selectedDirectionOption ? [selectedDirectionOption] : [],
    onChange: handleSelectChange('terms_direction'),
    singleSelection: {
      asPlainText: true
    }
  })))));
};
exports.SplitByTermsUI = SplitByTermsUI;
SplitByTermsUI.propTypes = {
  intl: _propTypes.default.object,
  model: _propTypes.default.object,
  onChange: _propTypes.default.func,
  indexPattern: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  fields: _propTypes.default.object,
  uiRestrictions: _propTypes.default.object,
  seriesQuantity: _propTypes.default.object
};
const SplitByTerms = exports.SplitByTerms = (0, _i18nReact.injectI18n)(SplitByTermsUI);