"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceVars = replaceVars;
var _rison = require("@kbn/rison");
var _handlebars = _interopRequireWildcard(require("@kbn/handlebars"));
var _i18n = require("@kbn/i18n");
var _empty_label = require("../../../../common/empty_label");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const handlebars = _handlebars.default.create();
function createSerializationHelper(fnName, serializeFn) {
  return (...args) => {
    const {
      hash
    } = args.slice(-1)[0];
    const hasHash = Object.keys(hash).length > 0;
    const hasValues = args.length > 1;
    if (hasHash && hasValues) {
      throw new Error(`[${fnName}]: both value list and hash are not supported`);
    }
    if (hasHash) {
      if (Object.values(hash).some(v => typeof v === 'undefined')) throw new Error(`[${fnName}]: unknown variable`);
      return serializeFn(hash);
    } else {
      const values = args.slice(0, -1);
      if (values.some(value => typeof value === 'undefined')) throw new Error(`[${fnName}]: unknown variable`);
      if (values.length === 0) throw new Error(`[${fnName}]: unknown variable`);
      if (values.length === 1) return serializeFn(values[0]);
      return serializeFn(values);
    }
  };
}
handlebars.registerHelper('rison', createSerializationHelper('rison', v => (0, _rison.encode)(v)));
handlebars.registerHelper('encodeURIComponent', component => {
  const str = String(component);
  return encodeURIComponent(str);
});
function replaceVars(str, args = {}, vars = {}, compileOptions = {}) {
  try {
    /** we need add '[]' for emptyLabel because this value contains special characters.
     * @see (https://handlebarsjs.com/guide/expressions.html#literal-segments) **/
    const template = handlebars[_handlebars.compileFnName](str.split(_empty_label.emptyLabel).join(`[${_empty_label.emptyLabel}]`), {
      strict: true,
      knownHelpersOnly: true,
      knownHelpers: {
        rison: true,
        encodeURIComponent: true
      },
      ...compileOptions
    });
    const string = template({
      ...vars,
      args
    });
    return string;
  } catch (e) {
    // user is probably typing and so its not formed correctly
    if (e.toString().indexOf('Parse error') !== -1) {
      return str;

      // Unknown variable
    } else if (e.message.indexOf('not defined in') !== -1) {
      const badVar = e.message.split(/"/)[1];
      e.error = {
        caused_by: {
          reason: _i18n.i18n.translate('visTypeTimeseries.replaceVars.errors.unknownVarDescription', {
            defaultMessage: '{badVar} is an unknown variable',
            values: {
              badVar: '{{' + badVar + '}}'
            }
          }),
          title: _i18n.i18n.translate('visTypeTimeseries.replaceVars.errors.unknownVarTitle', {
            defaultMessage: 'Error processing your markdown'
          })
        }
      };
    } else {
      e.error = {
        caused_by: {
          reason: _i18n.i18n.translate('visTypeTimeseries.replaceVars.errors.markdownErrorDescription', {
            defaultMessage: 'Please verify you are only using markdown, known variables, and built-in Handlebars expressions'
          }),
          title: _i18n.i18n.translate('visTypeTimeseries.replaceVars.errors.markdownErrorTitle', {
            defaultMessage: 'Error processing your markdown'
          })
        }
      };
    }
    return e;
  }
}