"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComboBoxSelect = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _services = require("../../../../services");
var _switch_mode_popover = require("./switch_mode_popover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal **/

/** @internal **/

const toComboBoxOptions = options => options.map(({
  name,
  title,
  id
}) => ({
  label: name ? name : title,
  id
}));
const ComboBoxSelect = ({
  fetchedIndex,
  onIndexChange,
  onModeChange,
  disabled,
  placeholder,
  allowSwitchMode,
  'data-test-subj': dataTestSubj
}) => {
  const [availableIndexes, setAvailableIndexes] = (0, _react.useState)([]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const onComboBoxChange = (0, _react.useCallback)(([selected]) => {
    onIndexChange(selected ? {
      id: selected.id
    } : '');
  }, [onIndexChange]);
  (0, _react.useEffect)(() => {
    let options = [];
    const {
      indexPattern,
      indexPatternString
    } = fetchedIndex;
    if (indexPattern || indexPatternString) {
      if (!indexPattern) {
        options = [{
          label: indexPatternString !== null && indexPatternString !== void 0 ? indexPatternString : ''
        }];
      } else {
        options = [{
          id: indexPattern.id,
          label: indexPattern.getName()
        }];
      }
    }
    setSelectedOptions(options);
  }, [fetchedIndex]);
  (0, _react.useEffect)(() => {
    async function fetchIndexes() {
      setAvailableIndexes(await (0, _services.getDataViewsStart)().getIdsWithTitle());
    }
    fetchIndexes();
  }, []);
  const isInvalid = Boolean(fetchedIndex.missedIndex);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    singleSelection: {
      asPlainText: true
    },
    isInvalid: isInvalid,
    onChange: onComboBoxChange,
    options: toComboBoxOptions(availableIndexes),
    selectedOptions: selectedOptions,
    isDisabled: disabled,
    placeholder: isInvalid ? _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.noDataView', {
      defaultMessage: 'Data view not found'
    }) : placeholder,
    "data-test-subj": dataTestSubj
  }, allowSwitchMode && {
    append: /*#__PURE__*/_react.default.createElement(_switch_mode_popover.SwitchModePopover, {
      onModeChange: onModeChange,
      fetchedIndex: fetchedIndex,
      useKibanaIndices: true
    })
  }));
};
exports.ComboBoxSelect = ComboBoxSelect;