"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggToComponent = void 0;
var _moving_average = require("../aggs/moving_average");
var _derivative = require("../aggs/derivative");
var _calculation = require("../aggs/calculation");
var _std_agg = require("../aggs/std_agg");
var _percentile = require("../aggs/percentile");
var _cumulative_sum = require("../aggs/cumulative_sum");
var _std_deviation = require("../aggs/std_deviation");
var _std_sibling = require("../aggs/std_sibling");
var _series_agg = require("../aggs/series_agg");
var _serial_diff = require("../aggs/serial_diff");
var _positive_only = require("../aggs/positive_only");
var _filter_ratio = require("../aggs/filter_ratio");
var _percentile_rank = require("../aggs/percentile_rank");
var _static = require("../aggs/static");
var _math = require("../aggs/math");
var _top_hit = require("../aggs/top_hit");
var _positive_rate = require("../aggs/positive_rate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const aggToComponent = exports.aggToComponent = {
  count: _std_agg.StandardAgg,
  avg: _std_agg.StandardAgg,
  max: _std_agg.StandardAgg,
  min: _std_agg.StandardAgg,
  sum: _std_agg.StandardAgg,
  std_deviation: _std_deviation.StandardDeviationAgg,
  sum_of_squares: _std_agg.StandardAgg,
  variance: _std_agg.StandardAgg,
  avg_bucket: _std_sibling.StandardSiblingAgg,
  max_bucket: _std_sibling.StandardSiblingAgg,
  min_bucket: _std_sibling.StandardSiblingAgg,
  sum_bucket: _std_sibling.StandardSiblingAgg,
  variance_bucket: _std_sibling.StandardSiblingAgg,
  sum_of_squares_bucket: _std_sibling.StandardSiblingAgg,
  std_deviation_bucket: _std_sibling.StandardSiblingAgg,
  percentile: _percentile.PercentileAgg,
  percentile_rank: _percentile_rank.PercentileRankAgg,
  cardinality: _std_agg.StandardAgg,
  value_count: _std_agg.StandardAgg,
  calculation: _calculation.CalculationAgg,
  cumulative_sum: _cumulative_sum.CumulativeSumAgg,
  moving_average: _moving_average.MovingAverageAgg,
  derivative: _derivative.DerivativeAgg,
  series_agg: _series_agg.SeriesAgg,
  serial_diff: _serial_diff.SerialDiffAgg,
  filter_ratio: _filter_ratio.FilterRatioAgg,
  positive_only: _positive_only.PositiveOnlyAgg,
  static: _static.Static,
  math: _math.MathAgg,
  top_hit: _top_hit.TopHitAgg,
  positive_rate: _positive_rate.PositiveRateAgg
};