"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Aggs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _agg = require("./agg");
var _collection_actions = require("../lib/collection_actions");
var _new_metric_agg_fn = require("../lib/new_metric_agg_fn");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-ignore

const DROPPABLE_ID = 'aggs_dnd';
class Aggs extends _react.PureComponent {
  render() {
    const {
      panel,
      model,
      fields,
      name,
      uiRestrictions,
      onChange
    } = this.props;
    const list = model.metrics;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: `${DROPPABLE_ID}:${model.id}`,
      type: "MICRO",
      spacing: "s"
    }, list.map((row, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      spacing: "s",
      key: row.id,
      index: idx,
      customDragHandle: true,
      draggableId: `${DROPPABLE_ID}:${model.id}:${row.id}`
    }, provided => /*#__PURE__*/_react.default.createElement(_agg.Agg, {
      key: row.id,
      disableDelete: list.length < 2,
      fields: fields,
      name: name,
      model: row,
      onAdd: () => (0, _collection_actions.handleAdd)(this.props, _new_metric_agg_fn.newMetricAggFn),
      onModelChange: onChange,
      onDelete: () => (0, _collection_actions.handleDelete)(this.props, row),
      panel: panel,
      series: model,
      siblings: list,
      uiRestrictions: uiRestrictions,
      dragHandleProps: provided.dragHandleProps
    }))));
  }
}
exports.Aggs = Aggs;