"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelionVisComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
var _i18n = require("@kbn/i18n");
var _series = require("./series");
var _panel_utils = require("../helpers/panel_utils");
var _chart_constants = require("../helpers/chart_constants");
var _plugin_services = require("../helpers/plugin_services");
require("./timelion_vis.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DefaultYAxis = () => /*#__PURE__*/_react.default.createElement(_charts.Axis, {
  id: "left",
  domain: (0, _panel_utils.withStaticPadding)({
    fit: false,
    min: NaN,
    max: NaN
  }),
  position: _charts.Position.Left,
  groupId: `${_panel_utils.MAIN_GROUP_ID}`
});
const renderYAxis = series => {
  const yAxisOptions = (0, _panel_utils.extractAllYAxis)(series);
  const defaultFormatter = x => {
    return (0, _plugin_services.getFieldFormats)().getInstance('number').convert(x);
  };
  const yAxis = yAxisOptions.map((option, index) => /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    groupId: option.groupId,
    key: index,
    id: option.id,
    title: option.title,
    position: option.position,
    tickFormat: option.tickFormat || defaultFormatter,
    gridLine: {
      visible: !index
    },
    domain: option.domain
  }));
  return yAxis.length ? yAxis : /*#__PURE__*/_react.default.createElement(DefaultYAxis, null);
};
const TimelionVisComponent = ({
  interval,
  seriesList,
  renderComplete,
  onBrushEvent,
  ariaLabel,
  syncTooltips,
  syncCursor
}) => {
  var _window$_echDebugStat;
  const kibana = (0, _public.useKibana)();
  const chartRef = (0, _react.useRef)(null);
  const chart = seriesList.list;
  const chartsService = (0, _plugin_services.getCharts)();
  const chartBaseTheme = chartsService.theme.useChartsBaseTheme();
  const handleCursorUpdate = (0, _public2.useActiveCursor)(chartsService.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const brushEndListener = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    onBrushEvent({
      gte: x[0],
      lte: x[1]
    });
  }, [onBrushEvent]);
  const onRenderChange = (0, _react.useCallback)(isRendered => {
    if (isRendered) {
      renderComplete();
    }
  }, [renderComplete]);
  const title = (0, _react.useMemo)(() => (0, _lodash.last)((0, _lodash.compact)((0, _lodash.map)(seriesList.list, '_title'))) || '', [seriesList.list]);
  const tickFormat = (0, _react.useMemo)(() => (0, _panel_utils.createTickFormat)(interval, kibana.services.timefilter, kibana.services.uiSettings), [interval, kibana.services.timefilter, kibana.services.uiSettings]);
  const legend = (0, _react.useMemo)(() => {
    const legendPosition = {
      floating: true,
      floatingColumns: 1,
      vAlign: _charts.Position.Top,
      hAlign: _charts.Position.Left,
      direction: _charts.LayoutDirection.Vertical
    };
    let showLegend = true;
    chart.forEach(series => {
      var _series$_global;
      if ((_series$_global = series._global) !== null && _series$_global !== void 0 && _series$_global.legend) {
        var _series$_global$legen, _series$_global2;
        const {
          show = true,
          position,
          noColumns = legendPosition.floatingColumns
        } = (_series$_global$legen = (_series$_global2 = series._global) === null || _series$_global2 === void 0 ? void 0 : _series$_global2.legend) !== null && _series$_global$legen !== void 0 ? _series$_global$legen : {};
        if ((0, _panel_utils.validateLegendPositionValue)(position)) {
          const [vAlign, hAlign] = position.split('');
          legendPosition.vAlign = vAlign === 'n' ? _charts.Position.Top : _charts.Position.Bottom;
          legendPosition.hAlign = hAlign === 'e' ? _charts.Position.Right : _charts.Position.Left;
        }
        if (!show) {
          showLegend = false;
        }
        if (noColumns !== undefined) {
          legendPosition.floatingColumns = noColumns;
        }
      }
    });
    return {
      legendPosition,
      showLegend
    };
  }, [chart]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "timelionChart",
    "data-test-subj": "timelionChart"
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    className: "timelionChart__topTitle",
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title)), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    ref: chartRef,
    renderer: "canvas",
    size: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    snap: true,
    headerFormatter: ({
      value
    }) => tickFormat(value),
    type: _charts.TooltipType.VerticalCursor
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    debugState: (_window$_echDebugStat = window._echDebugStateFlag) !== null && _window$_echDebugStat !== void 0 ? _window$_echDebugStat : false,
    onBrushEnd: brushEndListener,
    showLegend: legend.showLegend,
    showLegendExtra: true,
    legendPosition: legend.legendPosition,
    onRenderChange: onRenderChange,
    onPointerUpdate: syncCursor ? handleCursorUpdate : undefined,
    externalPointerEvents: {
      tooltip: {
        visible: syncTooltips,
        placement: _charts.Placement.Right
      }
    },
    baseTheme: chartBaseTheme,
    ariaLabel: ariaLabel,
    ariaUseDefaultSummary: !ariaLabel,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: tickFormat,
    gridLine: {
      visible: false
    }
  }), renderYAxis(chart), chart.map((data, index) => {
    const visData = {
      ...data
    };
    const SeriesComponent = data.bars ? _series.BarSeriesComponent : _series.AreaSeriesComponent;
    if (!visData.color) {
      visData.color = _chart_constants.colors[index % _chart_constants.colors.length];
    }
    return /*#__PURE__*/_react.default.createElement(SeriesComponent, {
      key: `${index}-${visData.label}`,
      visData: visData,
      index: chart.length - index,
      groupId: `${visData.yaxis ? visData.yaxis : _panel_utils.MAIN_GROUP_ID}`
    });
  })));
};
exports.TimelionVisComponent = TimelionVisComponent;