"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelionExpressionInput = TimelionExpressionInput;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _monaco = require("@kbn/monaco");
var _public = require("@kbn/kibana-react-plugin/public");
var _codeEditor = require("@kbn/code-editor");
var _timelion_expression_input_helpers = require("./timelion_expression_input_helpers");
var _arg_value_suggestions = require("../helpers/arg_value_suggestions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LANGUAGE_ID = 'timelion_expression';
_monaco.monaco.languages.register({
  id: LANGUAGE_ID
});
function TimelionExpressionInput({
  value,
  setValue
}) {
  const functionList = (0, _react.useRef)([]);
  const kibana = (0, _public.useKibana)();
  const argValueSuggestions = (0, _react.useMemo)(_arg_value_suggestions.getArgValueSuggestions, []);
  const provideCompletionItems = (0, _react.useCallback)(async (model, position) => {
    const text = model.getValue();
    const wordUntil = model.getWordUntilPosition(position);
    const wordRange = new _monaco.monaco.Range(position.lineNumber, wordUntil.startColumn, position.lineNumber, wordUntil.endColumn);
    const suggestions = await (0, _timelion_expression_input_helpers.suggest)(text, functionList.current,
    // it's important to offset the cursor position on 1 point left
    // because of PEG parser starts the line with 0, but monaco with 1
    position.column - 1, argValueSuggestions);
    return {
      suggestions: suggestions ? suggestions.list.map(s => (0, _timelion_expression_input_helpers.getSuggestion)(s, suggestions.type, wordRange)) : []
    };
  }, [argValueSuggestions]);
  const provideHover = (0, _react.useCallback)(async (model, position) => {
    const suggestions = await (0, _timelion_expression_input_helpers.suggest)(model.getValue(), functionList.current,
    // it's important to offset the cursor position on 1 point left
    // because of PEG parser starts the line with 0, but monaco with 1
    position.column - 1, argValueSuggestions);
    return {
      contents: suggestions ? suggestions.list.map(s => ({
        value: s.help
      })) : []
    };
  }, [argValueSuggestions]);
  (0, _react.useEffect)(() => {
    const abortController = new AbortController();
    if (kibana.services.http) {
      kibana.services.http.get('../internal/timelion/functions', {
        signal: abortController.signal
      }).then(data => {
        functionList.current = data;
      });
    }
    return () => {
      abortController.abort();
    };
  }, [kibana.services.http]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "timExpressionInput"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "timelion.vis.expressionLabel",
    defaultMessage: "Timelion expression"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "timExpressionInput__editor"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "timExpressionInput__absolute",
    "data-test-subj": "timelionCodeEditor"
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: LANGUAGE_ID,
    value: value,
    onChange: setValue,
    suggestionProvider: {
      triggerCharacters: ['.', ',', '(', '=', ':'],
      provideCompletionItems
    },
    hoverProvider: {
      provideHover
    },
    options: {
      fixedOverflowWidgets: true,
      fontSize: 14,
      folding: false,
      lineNumbers: 'off',
      scrollBeyondLastLine: false,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    languageConfiguration: {
      autoClosingPairs: [{
        open: '(',
        close: ')'
      }]
    }
  }))));
}