"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = exports.config = void 0;
var _config = require("../config");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const config = exports.config = {
  exposeToBrowser: {
    readOnly: true
  },
  schema: _config.configSchema
};
const plugin = initializerContext => ({
  setup(core, plugins) {
    const {
      readOnly
    } = initializerContext.config.get();
    if (readOnly) {
      plugins.visualizations.registerReadOnlyVisType(_common.VIS_TYPE_TABLE);
    }
    return {};
  },
  start() {}
});
exports.plugin = plugin;