"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _common = require("../common");
var _table_vis_options_lazy = require("./components/table_vis_options_lazy");
var _to_ast = require("./to_ast");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const tableVisTypeDefinition = exports.tableVisTypeDefinition = {
  name: _common.VIS_TYPE_TABLE,
  title: _i18n.i18n.translate('visTypeTable.tableVisTitle', {
    defaultMessage: 'Data table'
  }),
  icon: 'visTable',
  description: _i18n.i18n.translate('visTypeTable.tableVisDescription', {
    defaultMessage: 'Display data in rows and columns.'
  }),
  getSupportedTriggers: () => {
    return [_public2.VIS_EVENT_TO_TRIGGER.filter];
  },
  visConfig: {
    defaults: {
      perPage: 10,
      showPartialRows: false,
      showMetricsAtAllLevels: false,
      showTotal: false,
      showToolbar: false,
      totalFunc: 'sum',
      percentageCol: '',
      autoFitRowToContent: false
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: _table_vis_options_lazy.TableOptions,
    schemas: [{
      group: _public.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeTable.tableVisEditorConfig.schemas.metricTitle', {
        defaultMessage: 'Metric'
      }),
      aggFilter: ['!geo_centroid', '!geo_bounds', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      aggSettings: {
        top_hits: {
          allowStrings: true
        }
      },
      min: 1,
      defaults: [{
        type: 'count',
        schema: 'metric'
      }]
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'bucket',
      title: _i18n.i18n.translate('visTypeTable.tableVisEditorConfig.schemas.bucketTitle', {
        defaultMessage: 'Split rows'
      }),
      aggFilter: ['!filter', '!sampler', '!diversified_sampler', '!multi_terms', '!significant_text', '!rare_terms']
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'split',
      title: _i18n.i18n.translate('visTypeTable.tableVisEditorConfig.schemas.splitTitle', {
        defaultMessage: 'Split table'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!filter', '!sampler', '!diversified_sampler', '!multi_terms', '!significant_text', '!rare_terms']
    }]
  },
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  hasPartialRows: vis => vis.params.showPartialRows,
  hierarchicalData: vis => vis.params.showPartialRows || vis.params.showMetricsAtAllLevels,
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => {
    const {
      convertToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
    return vis ? convertToLens(vis, timefilter) : null;
  },
  getExpressionVariables: async (vis, timeFilter) => {
    const {
      convertToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertToLens(vis, timeFilter) : null)
    };
  }
};