"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableVisRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const TableVisualizationComponent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/table_visualization'))));

/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const getTableVisRenderer = (core, usageCollection) => ({
  name: 'table_vis',
  reuseDomNode: true,
  render: async (domNode, {
    visData,
    visConfig,
    canNavigateToLens
  }, handlers) => {
    var _visData$table;
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const showNoResult = ((_visData$table = visData.table) === null || _visData$table === void 0 ? void 0 : _visData$table.rows.length) === 0 || !visData.table && visData.tables.length === 0;
    const renderCompete = () => {
      const containerType = extractContainerType(handlers.getExecutionContext());
      const visualizationType = 'agg_based';
      if (containerType) {
        const counterEvents = [`render_${visualizationType}_table`, !visData.table ? `render_${visualizationType}_table_split` : undefined, canNavigateToLens ? `render_${visualizationType}_table_convertable` : undefined].filter(Boolean);
        usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, counterEvents);
      }
      handlers.done();
    };
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_public.VisualizationContainer, {
      "data-test-subj": "tbvChartContainer",
      handlers: handlers,
      renderComplete: renderCompete,
      showNoResult: showNoResult
    }, /*#__PURE__*/_react.default.createElement(TableVisualizationComponent, {
      core: core,
      handlers: handlers,
      visData: visData,
      visConfig: visConfig,
      renderComplete: renderCompete
    }))), domNode);
  }
});
exports.getTableVisRenderer = getTableVisRenderer;