"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableVisControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _public3 = require("@kbn/share-plugin/public");
var _services = require("../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TableVisControls = exports.TableVisControls = /*#__PURE__*/(0, _react.memo)(({
  dataGridAriaLabel,
  filename,
  columns,
  rows
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(state => !state), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const {
    services: {
      uiSettings
    }
  } = (0, _public.useKibana)();
  const detectedFormulasInTable = _public2.exporters.tableHasFormulas(columns, rows);
  const onClickExport = (0, _react.useCallback)(formatted => {
    const csvSeparator = uiSettings.get(_public3.CSV_SEPARATOR_SETTING);
    const quoteValues = uiSettings.get(_public3.CSV_QUOTE_VALUES_SETTING);
    const content = _public2.exporters.datatableToCSV({
      type: 'datatable',
      columns,
      rows
    }, {
      csvSeparator,
      quoteValues,
      formatFactory: (0, _services.getFormatService)().deserialize,
      raw: !formatted,
      escapeFormulaValues: false
    });
    (0, _public3.downloadFileAs)(`${filename || 'unsaved'}.csv`, {
      content,
      type: _public2.exporters.CSV_MIME_TYPE
    });
  }, [columns, rows, filename, uiSettings]);
  const exportBtnAriaLabel = _i18n.i18n.translate('visTypeTable.vis.controls.exportButtonAriaLabel', {
    defaultMessage: 'Export {dataGridAriaLabel} as CSV',
    values: {
      dataGridAriaLabel
    }
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": exportBtnAriaLabel,
    size: "xs",
    iconType: "exportAction",
    color: "text",
    className: "euiDataGrid__controlBtn",
    onClick: togglePopover
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTable.vis.controls.exportButtonLabel",
    defaultMessage: "Export"
  }));
  const downloadButton = detectedFormulasInTable ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('visTypeTable.vis.controls.exportButtonFormulasWarning', {
      defaultMessage: 'Your CSV contains characters that spreadsheet applications might interpret as formulas.'
    })
  }, button) : button;
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "rawCsv",
    onClick: () => onClickExport(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTable.vis.controls.rawCSVButtonLabel",
    defaultMessage: "Raw"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "csv",
    onClick: () => onClickExport(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTable.vis.controls.formattedCSVButtonLabel",
    defaultMessage: "Formatted"
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "dataTableExportData",
    button: downloadButton,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    className: "eui-textNoWrap",
    items: items
  }));
});