"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markdownVisDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _markdown_options = require("./markdown_options");
var _settings_options_lazy = require("./settings_options_lazy");
var _to_ast = require("./to_ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const markdownVisDefinition = exports.markdownVisDefinition = {
  name: 'markdown',
  title: 'Markdown',
  isAccessible: true,
  icon: 'visText',
  group: _public2.VisGroups.TOOLS,
  titleInWizard: _i18n.i18n.translate('visTypeMarkdown.markdownTitleInWizard', {
    defaultMessage: 'Text'
  }),
  description: _i18n.i18n.translate('visTypeMarkdown.markdownDescription', {
    defaultMessage: 'Add text and images to your dashboard.'
  }),
  toExpressionAst: _to_ast.toExpressionAst,
  visConfig: {
    defaults: {
      fontSize: 12,
      openLinksInNewTab: false,
      markdown: ''
    }
  },
  editorConfig: {
    optionTabs: [{
      name: 'advanced',
      title: _i18n.i18n.translate('visTypeMarkdown.tabs.dataText', {
        defaultMessage: 'Data'
      }),
      editor: _markdown_options.MarkdownOptions
    }, {
      name: 'options',
      title: _i18n.i18n.translate('visTypeMarkdown.tabs.optionsText', {
        defaultMessage: 'Options'
      }),
      editor: _settings_options_lazy.SettingsOptions
    }],
    enableAutoApply: true,
    defaultSize: _public.DefaultEditorSize.LARGE
  },
  options: {
    showTimePicker: false,
    showFilterBar: false,
    showQueryInput: false
  },
  inspectorAdapters: {}
};