"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequiredNumberInputOption = RequiredNumberInputOption;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Use only this component instead of NumberInputOption in 'number_input.tsx'.
 * It is required for compatibility with TS 3.7.0
 *
 * @param {number} props.value Should be numeric only
 */
function RequiredNumberInputOption({
  disabled,
  error,
  isInvalid,
  label,
  max,
  min,
  paramName,
  step,
  value,
  setValue,
  setValidity,
  'data-test-subj': dataTestSubj
}) {
  const isValid = value !== null;
  (0, _react.useEffect)(() => {
    setValidity(paramName, isValid);
    return () => setValidity(paramName, true);
  }, [isValid, paramName, setValidity]);
  const onChange = (0, _react.useCallback)(ev => setValue(paramName, isNaN(ev.target.valueAsNumber) ? null : ev.target.valueAsNumber), [setValue, paramName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    error: error,
    isInvalid: isInvalid,
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    fullWidth: true,
    required: true,
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    isInvalid: !isValid,
    step: step,
    max: max,
    min: min,
    value: value === null ? '' : value,
    onChange: onChange
  }));
}