"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentilesEditor = PercentilesEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _number_list = require("./components/number_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function PercentilesEditor({
  agg,
  showValidation,
  value = [],
  setTouched,
  setValidity,
  setValue
}) {
  const label = _i18n.i18n.translate('visDefaultEditor.controls.percentiles.percentsLabel', {
    defaultMessage: 'Percents'
  });
  const [isValid, setIsValid] = (0, _react.useState)(true);
  const setModelValidity = (0, _react.useCallback)(isListValid => {
    setIsValid(isListValid);
    setValidity(isListValid);
  }, [setValidity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    labelType: "legend",
    fullWidth: true,
    id: `visEditorPercentileLabel${agg.id}`,
    isInvalid: showValidation ? !isValid : false,
    display: "rowCompressed",
    "data-test-subj": "visEditorPercentile"
  }, /*#__PURE__*/_react.default.createElement(_number_list.NumberList, {
    labelledbyId: `visEditorPercentileLabel${agg.id}-legend`,
    numberArray: value,
    range: "[0,100]",
    disallowDuplicates: true,
    unitName: _i18n.i18n.translate('visDefaultEditor.controls.percentileRanks.percentUnitNameText', {
      defaultMessage: 'percent'
    }),
    showValidation: showValidation,
    onChange: setValue,
    setTouched: setTouched,
    setValidity: setModelValidity
  }));
}