"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpRangesParamEditor = IpRangesParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _from_to_list = require("./components/from_to_list");
var _mask_list = require("./components/mask_list");
var _ip_range_type = require("./ip_range_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function IpRangesParamEditor({
  agg,
  value = {
    fromTo: [],
    mask: []
  },
  setTouched,
  setValue,
  setValidity,
  showValidation
}) {
  const handleMaskListChange = (0, _react.useCallback)(items => setValue({
    ...value,
    [_ip_range_type.IpRangeTypes.MASK]: items
  }), [setValue, value]);
  const handleFromToListChange = (0, _react.useCallback)(items => setValue({
    ...value,
    [_ip_range_type.IpRangeTypes.FROM_TO]: items
  }), [setValue, value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    id: `visEditorIpRange${agg.id}`,
    display: "rowCompressed"
  }, agg.params.ipRangeType === _ip_range_type.IpRangeTypes.MASK ? /*#__PURE__*/_react.default.createElement(_mask_list.MaskList, {
    list: value.mask,
    showValidation: showValidation,
    onBlur: setTouched,
    onChange: handleMaskListChange,
    setValidity: setValidity
  }) : /*#__PURE__*/_react.default.createElement(_from_to_list.FromToList, {
    list: value.fromTo,
    showValidation: showValidation,
    onBlur: setTouched,
    onChange: handleFromToListChange,
    setValidity: setValidity
  }));
}