"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeExcludeParamEditor = IncludeExcludeParamEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-plugin/public");
var _string = require("./string");
var _simple_number_list = require("./components/simple_number_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  isNumberType
} = _public.search.aggs;
function IncludeExcludeParamEditor(props) {
  const {
    agg,
    value,
    setValue
  } = props;
  const isAggOfNumberType = isNumberType(agg);

  // This useEffect converts value from string type to number and back when the field type is changed
  (0, _react.useEffect)(() => {
    if (isAggOfNumberType && !Array.isArray(value) && value !== undefined) {
      const numberArray = value.split('|').map(item => parseFloat(item)).filter(number => Number.isFinite(number));
      setValue(numberArray.length ? numberArray : ['']);
    } else if (!isAggOfNumberType && Array.isArray(value) && value !== undefined) {
      setValue(value.filter(item => item !== '').join('|'));
    }
  }, [isAggOfNumberType, setValue, value]);
  return isAggOfNumberType ? /*#__PURE__*/_react.default.createElement(_simple_number_list.SimpleNumberList, (0, _extends2.default)({}, props, {
    value: value
  })) : /*#__PURE__*/_react.default.createElement(_string.StringParamEditor, (0, _extends2.default)({}, props, {
    value: value
  }));
}