"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterRow = FilterRow;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function FilterRow({
  id,
  arrayIndex,
  customLabel,
  value,
  autoFocus,
  disableRemove,
  dataTestSubj,
  agg,
  onChangeValue,
  onRemoveFilter
}) {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    data,
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    },
    appName
  } = services;
  const [showCustomLabel, setShowCustomLabel] = (0, _react.useState)(false);
  const filterLabel = _i18n.i18n.translate('visDefaultEditor.controls.filters.filterLabel', {
    defaultMessage: 'Filter {index}',
    values: {
      index: arrayIndex + 1
    }
  });
  const onBlur = () => {
    if (value.query.length > 0) {
      // Store filter to the query log so that it is available in autocomplete.
      data.query.addToQueryLog(appName, value);
    }
  };
  const FilterControl = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "tag",
    "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.filters.toggleFilterButtonAriaLabel', {
      defaultMessage: 'Toggle filter label'
    }),
    "aria-expanded": showCustomLabel,
    "aria-controls": `visEditorFilterLabel${arrayIndex}`,
    onClick: () => setShowCustomLabel(!showCustomLabel)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    disabled: disableRemove,
    "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.filters.removeFilterButtonAriaLabel', {
      defaultMessage: 'Remove this filter'
    }),
    onClick: () => onRemoveFilter(id)
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: `${filterLabel}${customLabel ? ` - ${customLabel}` : ''}`,
    labelAppend: FilterControl,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    query: value,
    indexPatterns: [agg.getIndexPattern()],
    onChange: query => onChangeValue(id, query, customLabel),
    onBlur: onBlur,
    disableAutoFocus: !autoFocus,
    dataTestSubj: dataTestSubj,
    bubbleSubmitEvent: true,
    languageSwitcherPopoverAnchorPosition: "leftDown",
    size: "s",
    appName: appName
  })), showCustomLabel ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: `visEditorFilterLabel${arrayIndex}`,
    label: _i18n.i18n.translate('visDefaultEditor.controls.filters.definiteFilterLabel', {
      defaultMessage: 'Filter {index} label',
      description: "'Filter {index}' represents the name of the filter as a noun, similar to 'label for filter 1'.",
      values: {
        index: arrayIndex + 1
      }
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: customLabel,
    placeholder: _i18n.i18n.translate('visDefaultEditor.controls.filters.labelPlaceholder', {
      defaultMessage: 'Label'
    }),
    onChange: ev => onChangeValue(id, value, ev.target.value),
    fullWidth: true,
    compressed: true
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}