"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedFilters = SelectedFilters;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/exploratory-view-plugin/public");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _selected_wildcards = require("./selected_wildcards");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 300px;
`;
function SelectedFilters({
  indexPattern,
  onChange,
  filters,
  invertFilter,
  clearValues
}) {
  const {
    uxUiFilters,
    urlParams: {
      searchTerm
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    transactionUrl
  } = uxUiFilters;
  const urlValues = transactionUrl !== null && transactionUrl !== void 0 ? transactionUrl : [];
  const hasValues = filters.some(filter => {
    var _filter$value;
    return ((_filter$value = filter.value) === null || _filter$value === void 0 ? void 0 : _filter$value.length) > 0;
  });
  return indexPattern && (hasValues || urlValues.length > 0 || searchTerm) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_selected_wildcards.SelectedWildcards, {
    indexPattern: indexPattern
  }), (filters !== null && filters !== void 0 ? filters : []).map(({
    name,
    title,
    fieldName,
    excluded
  }) => {
    var _uxUiFilters$name;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: name
    }, ((_uxUiFilters$name = uxUiFilters === null || uxUiFilters === void 0 ? void 0 : uxUiFilters[name]) !== null && _uxUiFilters$name !== void 0 ? _uxUiFilters$name : []).map(value => /*#__PURE__*/_react.default.createElement(FilterItem, {
      key: name + value,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_public.FilterValueLabel, {
      dataView: indexPattern,
      removeFilter: () => {
        onChange(name, (uxUiFilters === null || uxUiFilters === void 0 ? void 0 : uxUiFilters[name]).filter(valT => valT !== value));
      },
      invertFilter: ({
        negate
      }) => {
        invertFilter(name, value, negate);
      },
      field: fieldName,
      value: name === 'transactionUrl' ? formatUrlValue(value) : value,
      negate: !!excluded,
      label: title
    }))));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "uxSelectedFiltersClearFiltersButton",
    size: "xs",
    iconType: "cross",
    onClick: clearValues,
    "data-cy": "clearFilters"
  }, _i18n.i18n.translate('xpack.ux.clearFilters', {
    defaultMessage: 'Clear filters'
  })))) : null;
}
function formatUrlValue(val) {
  const maxUrlToDisplay = 30;
  const urlLength = val.length;
  if (urlLength < maxUrlToDisplay) {
    return val;
  }
  const urlObj = new URL(val);
  if (urlObj.pathname === '/') {
    return val;
  }
  const domainVal = urlObj.hostname;
  const extraLength = urlLength - maxUrlToDisplay;
  const extraDomain = domainVal.substring(0, extraLength);
  if (urlObj.pathname.length + 7 > maxUrlToDisplay) {
    return val.replace(domainVal, '..');
  }
  return val.replace(extraDomain, '..');
}