"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClientMetrics = ClientMetrics;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../translations");
var _translations2 = require("../ux_metrics/translations");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _metrics = require("./metrics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ClientMetrics() {
  const {
    urlParams: {
      percentile
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  return /*#__PURE__*/React.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-cy": `client-metrics`
  }, /*#__PURE__*/React.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, _translations.I18LABELS.pageLoad, " (", (0, _translations2.getPercentileLabel)(percentile), ")")), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(_metrics.Metrics, null))));
}