"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeRouteWrapper = void 0;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _lib = require("../lib/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uptimeRouteWrapper = (uptimeRoute, server) => ({
  ...uptimeRoute,
  options: {
    tags: ['access:uptime-read', ...(uptimeRoute !== null && uptimeRoute !== void 0 && uptimeRoute.writeAccess ? ['access:uptime-write'] : [])]
  },
  handler: async (context, request, response) => {
    const coreContext = await context.core;
    const {
      client: esClient
    } = coreContext.elasticsearch;
    const uptimeEsClient = new _lib.UptimeEsClient(coreContext.savedObjects.client, esClient.asCurrentUser, {
      request,
      uiSettings: coreContext.uiSettings,
      isDev: Boolean(server.isDev)
    });
    const res = await uptimeRoute.handler({
      uptimeEsClient,
      savedObjectsClient: coreContext.savedObjects.client,
      context,
      request,
      response,
      server
    });
    if (res instanceof _coreHttpRouterServerInternal.KibanaResponse) {
      return res;
    }
    return response.ok({
      body: {
        ...res,
        ...(await uptimeEsClient.getInspectData(uptimeRoute.path))
      }
    });
  }
});
exports.uptimeRouteWrapper = uptimeRouteWrapper;