"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimeOverviewLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/observability-plugin/public");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatSearchKey = (key, value) => `${key}: "${value}"`;
function isUptimeOverviewLocatorParams(args) {
  return args.search !== undefined || args.dateRangeEnd !== undefined || args.dateRangeStart !== undefined;
}
class UptimeOverviewLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _public.uptimeOverviewLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      let qs = '';
      if (isUptimeOverviewLocatorParams(params)) {
        qs = Object.entries(params).map(([key, value]) => {
          if (value) {
            return `${key}=${value}`;
          }
        }).join('&');
      } else {
        const searchParams = [];
        if (params.host) searchParams.push(formatSearchKey('host.name', params.host));
        if (params.container) searchParams.push(formatSearchKey('container.id', params.container));
        if (params.pod) searchParams.push(formatSearchKey('kubernetes.pod.uid', params.pod));
        if (params.ip) {
          searchParams.push(formatSearchKey(`host.ip`, params.ip));
          searchParams.push(formatSearchKey(`monitor.ip`, params.ip));
        }
        if (searchParams.length > 0) {
          qs = `search=${searchParams.join(' OR ')}`;
        }
      }
      const path = `${_constants.OVERVIEW_ROUTE}${qs ? `?${qs}` : ''}`;
      return {
        app: 'uptime',
        path,
        state: {}
      };
    });
  }
}
exports.UptimeOverviewLocatorDefinition = UptimeOverviewLocatorDefinition;