"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMonitorAlertRecords = exports.fetchConnectors = exports.fetchAnomalyAlertRecords = exports.fetchActionTypes = exports.disableAlertById = exports.createAlert = void 0;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _translations = require("../../../../common/rules/legacy_uptime/translations");
var _uptime_alerts = require("../../../../common/constants/uptime_alerts");
var _utils = require("./utils");
var _constants = require("../../../../common/constants");
var _alert_actions = require("../../../../common/rules/alert_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPTIME_AUTO_ALERT = 'UPTIME_AUTO';
const fetchConnectors = async () => {
  const response = await _utils.apiService.get(_constants.API_URLS.RULE_CONNECTORS);
  return response.map(({
    connector_type_id: actionTypeId,
    referenced_by_count: referencedByCount,
    is_preconfigured: isPreconfigured,
    is_deprecated: isDeprecated,
    is_missing_secrets: isMissingSecrets,
    is_system_action: isSystemAction,
    ...res
  }) => ({
    ...res,
    actionTypeId,
    referencedByCount,
    isDeprecated,
    isPreconfigured,
    isMissingSecrets,
    isSystemAction
  }));
};
exports.fetchConnectors = fetchConnectors;
const createAlert = async ({
  defaultActions,
  monitorId,
  selectedMonitor,
  defaultEmail
}) => {
  var _selectedMonitor$url;
  const actions = (0, _alert_actions.populateAlertActions)({
    defaultActions,
    defaultEmail,
    groupId: _uptime_alerts.MONITOR_STATUS.id,
    translations: {
      defaultActionMessage: _translations.MonitorStatusTranslations.defaultActionMessage,
      defaultRecoveryMessage: _translations.MonitorStatusTranslations.defaultRecoveryMessage,
      defaultSubjectMessage: _translations.MonitorStatusTranslations.defaultSubjectMessage,
      defaultRecoverySubjectMessage: _translations.MonitorStatusTranslations.defaultRecoverySubjectMessage
    }
  });
  const data = {
    actions,
    params: {
      numTimes: 1,
      timerangeUnit: 'm',
      timerangeCount: 1,
      shouldCheckStatus: true,
      shouldCheckAvailability: false,
      isAutoGenerated: true,
      search: `monitor.id : ${monitorId} `,
      filters: {
        'url.port': [],
        'observer.geo.name': [],
        'monitor.type': [],
        tags: []
      }
    },
    consumer: 'uptime',
    rule_type_id: _uptime_alerts.CLIENT_ALERT_TYPES.MONITOR_STATUS,
    schedule: {
      interval: '1m'
    },
    notify_when: 'onActionGroupChange',
    tags: [UPTIME_AUTO_ALERT],
    name: `${(selectedMonitor === null || selectedMonitor === void 0 ? void 0 : selectedMonitor.monitor.name) || (selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$url = selectedMonitor.url) === null || _selectedMonitor$url === void 0 ? void 0 : _selectedMonitor$url.full)}(Simple status alert)`,
    enabled: true,
    throttle: null
  };
  return await _utils.apiService.post(_constants.API_URLS.CREATE_RULE, data);
};
exports.createAlert = createAlert;
const fetchMonitorAlertRecords = async () => {
  const data = {
    page: 1,
    per_page: 500,
    filter: `alert.attributes.alertTypeId:(${_uptime_alerts.CLIENT_ALERT_TYPES.MONITOR_STATUS})`,
    default_search_operator: 'AND',
    sort_field: 'name.keyword',
    sort_order: 'asc',
    search_fields: ['name', 'tags'],
    search: 'UPTIME_AUTO'
  };
  return await _utils.apiService.get(_constants.API_URLS.RULES_FIND, data);
};
exports.fetchMonitorAlertRecords = fetchMonitorAlertRecords;
const fetchAnomalyAlertRecords = async ({
  monitorId
}) => {
  const data = {
    page: 1,
    per_page: 500,
    filter: `alert.attributes.alertTypeId:(${_uptime_alerts.CLIENT_ALERT_TYPES.DURATION_ANOMALY})`,
    default_search_operator: 'AND',
    sort_field: 'name.keyword',
    sort_order: 'asc'
  };
  const rawRules = await _utils.apiService.get(_constants.API_URLS.RULES_FIND, data);
  const monitorRule = rawRules.data.find(rule => rule.params.monitorId === monitorId);
  if (!monitorRule) return undefined;
  return (0, _public.transformRule)(monitorRule);
};
exports.fetchAnomalyAlertRecords = fetchAnomalyAlertRecords;
const disableAlertById = async ({
  alertId
}) => {
  return await _utils.apiService.delete(_constants.API_URLS.DELETE_RULE + alertId);
};
exports.disableAlertById = disableAlertById;
const fetchActionTypes = async () => {
  const response = await _utils.apiService.get(_constants.API_URLS.CONNECTOR_TYPES, {
    feature_id: 'uptime'
  });
  return response.map(({
    enabled_in_config: enabledInConfig,
    enabled_in_license: enabledInLicense,
    minimum_license_required: minimumLicenseRequired,
    supported_feature_ids: supportedFeatureIds,
    is_system_action_type: isSystemActionType,
    ...res
  }) => ({
    ...res,
    enabledInConfig,
    enabledInLicense,
    minimumLicenseRequired,
    supportedFeatureIds,
    isSystemActionType
  }));
};
exports.fetchActionTypes = fetchActionTypes;