"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simpleAlertEnabled = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _kibana_service = require("../../state/kibana_service");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const simpleAlertEnabled = (defaultActions, rule) => {
  const alertUrl = (0, _common.getUrlForAlert)(rule.id, _kibana_service.kibanaService.core.http.basePath.get());
  return {
    title: _i18n.i18n.translate('xpack.uptime.overview.alerts.enabled.success', {
      defaultMessage: 'Rule successfully enabled '
    }),
    text: (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: {
        application: _kibana_service.kibanaService.core.application
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.overview.alerts.enabled.success.description",
      defaultMessage: "A message will be sent to {actionConnectors} when this monitor is down.",
      values: {
        actionConnectors: /*#__PURE__*/_react.default.createElement("strong", null, defaultActions.map(({
          name
        }) => name).join(', '))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsSimpleAlertEnabledEditAlertLink",
      href: alertUrl
    }, _i18n.i18n.translate('xpack.uptime.enableAlert.editAlert', {
      defaultMessage: 'Edit alert'
    }))), _kibana_service.kibanaService.core)
  };
};
exports.simpleAlertEnabled = simpleAlertEnabled;