"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
exports.colorFromStatus = colorFromStatus;
exports.textFromStatus = textFromStatus;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _contexts = require("../../contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function colorFromStatus(color, status) {
  switch (status) {
    case 'succeeded':
      return color.success;
    case 'failed':
      return color.dangerBehindText;
    default:
      return 'default';
  }
}
function textFromStatus(status) {
  switch (status) {
    case 'succeeded':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.succeededMessage', {
        defaultMessage: 'Succeeded'
      });
    case 'failed':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.failedMessage', {
        defaultMessage: 'Failed'
      });
    case 'skipped':
      return _i18n.i18n.translate('xpack.uptime.synthetics.statusBadge.skippedMessage', {
        defaultMessage: 'Skipped'
      });
    default:
      return null;
  }
}
const StatusBadge = ({
  status,
  stepNo,
  isMobile
}) => {
  const theme = (0, _react.useContext)(_contexts.UptimeThemeContext);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, !isMobile && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textNoWrap"
  }, /*#__PURE__*/_react.default.createElement("strong", null, stepNo, "."))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: colorFromStatus(theme.colors, status)
  }, textFromStatus(status))));
};
exports.StatusBadge = StatusBadge;