"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicesForm = ({
  onChange,
  loading,
  formFields,
  fieldErrors,
  isDisabled
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.uptime.sourceConfiguration.indicesSectionTitle",
  defaultMessage: "Indices"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
  title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.heartbeatIndicesTitle",
    defaultMessage: "Uptime indices"
  })),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.heartbeatIndicesDescription",
    defaultMessage: "Index pattern for matching indices that contain Heartbeat data"
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  describedByIds: ['heartbeatIndices'],
  error: fieldErrors === null || fieldErrors === void 0 ? void 0 : fieldErrors.heartbeatIndices,
  fullWidth: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.heartbeatIndicesDefaultValue",
    defaultMessage: "The default value is {defaultValue}",
    values: {
      defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _constants.DYNAMIC_SETTINGS_DEFAULTS.heartbeatIndices)
    }
  }),
  isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.heartbeatIndices),
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.heartbeatIndicesLabel",
    defaultMessage: "Heartbeat indices"
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  "data-test-subj": `heartbeat-indices-input-${loading ? 'loading' : 'loaded'}`,
  fullWidth: true,
  disabled: isDisabled,
  isLoading: loading,
  value: (formFields === null || formFields === void 0 ? void 0 : formFields.heartbeatIndices) || '',
  onChange: event => onChange({
    heartbeatIndices: event.currentTarget.value
  })
}))));
exports.IndicesForm = IndicesForm;