"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingStatusColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../../contexts");
var _translations = require("../../../../../../common/translations/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPingStatusLabel = (status, ping) => {
  if (ping.monitor.type === _constants.MONITOR_TYPES.BROWSER) {
    return status === 'up' ? _translations.STATUS_COMPLETE_LABEL : _translations.STATUS_FAILED_LABEL;
  }
  return status === 'up' ? _translations.STATUS_UP_LABEL : _translations.STATUS_DOWN_LABEL;
};
const PingStatusColumn = ({
  pingStatus,
  item
}) => {
  const {
    colors: {
      dangerBehindText
    }
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  const timeStamp = (0, _moment.default)(item.timestamp);
  let checkedTime = '';
  if ((0, _moment.default)().diff(timeStamp, 'd') > 1) {
    checkedTime = timeStamp.format('ll LTS');
  } else {
    checkedTime = timeStamp.format('LTS');
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `xpack.synthetics.pingList.ping-${item.docId}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "eui-textCenter",
    color: pingStatus === _constants.STATUS.UP ? 'success' : dangerBehindText
  }, getPingStatusLabel(pingStatus, item)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.uptime.pingList.recencyMessage', {
    values: {
      fromNow: checkedTime
    },
    defaultMessage: 'Checked {fromNow}',
    description: 'A string used to inform our users how long ago Heartbeat pinged the selected host.'
  })));
};
exports.PingStatusColumn = PingStatusColumn;