"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLFlyoutView = MLFlyoutView;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var labels = _interopRequireWildcard(require("./translations"));
var _contexts = require("../../../contexts");
var _license_info = require("./license_info");
var _selectors = require("../../../state/selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MLFlyoutView({
  isCreatingJob,
  onClickCreate,
  onClose,
  canCreateMLJob
}) {
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const hasMlFeature = (0, _reactRedux.useSelector)(_selectors.hasMLFeatureSelector);
  const isLoadingMLJob = false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "s",
    "data-test-subj": "uptimeMLFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, labels.ENABLE_ANOMALY_DETECTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, !hasMlFeature && /*#__PURE__*/_react.default.createElement(_license_info.ShowLicenseInfo, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, labels.CREAT_ML_JOB_DESC), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.ml.enableAnomalyDetectionPanel.manageMLJobDescription",
    defaultMessage: "Once a job is created, you can manage it and see more details in the {mlJobsPageLink}.",
    values: {
      mlJobsPageLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsMLFlyoutViewLink",
        href: basePath + '/app/ml'
      }, labels.ML_MANAGEMENT_PAGE)
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("em", null, labels.TAKE_SOME_TIME_TEXT))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !canCreateMLJob && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: labels.ADD_JOB_PERMISSIONS_NEEDED,
    color: "primary",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.ml.enableAnomalyDetectionPanel.insufficient_permissions_add_job",
    defaultMessage: "You must have the Kibana privileges for Machine Learning to use this feature."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsMLFlyoutViewButton",
    onClick: () => onClose(),
    disabled: isCreatingJob || isLoadingMLJob
  }, labels.CANCEL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "uptimeMLCreateJobBtn",
    onClick: () => onClickCreate(),
    fill: true,
    isLoading: isCreatingJob,
    disabled: isCreatingJob || isLoadingMLJob || !hasMlFeature || !canCreateMLJob
  }, labels.CREATE_NEW_JOB)))));
}