"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationIssuesPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../shared_imports");
var _utils = require("../../../../lib/utils");
var _loading_issues_error = require("./loading_issues_error");
var _no_deprecation_issues = require("./no_deprecation_issues");
require("./_deprecation_issues_panel.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  warningDeprecationsTitle: _i18n.i18n.translate('xpack.upgradeAssistant.deprecationStats.warningDeprecationsTitle', {
    defaultMessage: 'Warning'
  }),
  criticalDeprecationsTitle: _i18n.i18n.translate('xpack.upgradeAssistant.deprecationStats.criticalDeprecationsTitle', {
    defaultMessage: 'Critical'
  })
};
const DeprecationIssuesPanel = props => {
  const {
    deprecationSource,
    linkUrl,
    criticalDeprecationsCount,
    warningDeprecationsCount,
    isLoading,
    errorMessage,
    setIsFixed
  } = props;
  const history = (0, _reactRouterDom.useHistory)();
  const hasError = !!errorMessage;
  const hasCriticalIssues = criticalDeprecationsCount > 0;
  const hasWarningIssues = warningDeprecationsCount > 0;
  const hasNoIssues = !isLoading && !hasError && !hasWarningIssues && !hasCriticalIssues;
  (0, _react.useEffect)(() => {
    if (!isLoading && !errorMessage) {
      setIsFixed(criticalDeprecationsCount === 0);
    }
  }, [setIsFixed, criticalDeprecationsCount, isLoading, errorMessage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, (0, _extends2.default)({
    "data-test-subj": props['data-test-subj'],
    className: "upgDeprecationIssuesPanel",
    layout: "horizontal",
    title: deprecationSource,
    titleSize: "xs"
  }, !hasNoIssues && (0, _shared_imports.reactRouterNavigate)(history, linkUrl)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), hasError ? /*#__PURE__*/_react.default.createElement(_loading_issues_error.LoadingIssuesError, null, errorMessage) : hasNoIssues ? /*#__PURE__*/_react.default.createElement(_no_deprecation_issues.NoDeprecationIssues, {
    "data-test-subj": "noDeprecationIssues"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "criticalDeprecations",
    className: "upgDeprecationIssuesPanel__stat",
    title: hasError ? '--' : hasCriticalIssues ? (0, _utils.getDeprecationsUpperLimit)(criticalDeprecationsCount) : /*#__PURE__*/_react.default.createElement(_no_deprecation_issues.NoDeprecationIssues, {
      isPartial: true,
      "data-test-subj": "noCriticalDeprecationIssues"
    }),
    titleElement: "span",
    description: i18nTexts.criticalDeprecationsTitle,
    titleColor: "danger",
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "warningDeprecations",
    className: "upgDeprecationIssuesPanel__stat",
    title: hasError ? '--' : hasWarningIssues ? (0, _utils.getDeprecationsUpperLimit)(warningDeprecationsCount) : /*#__PURE__*/_react.default.createElement(_no_deprecation_issues.NoDeprecationIssues, {
      isPartial: true,
      "data-test-subj": "noWarningDeprecationIssues"
    }),
    titleElement: "span",
    description: i18nTexts.warningDeprecationsTitle,
    isLoading: isLoading
  }))));
};
exports.DeprecationIssuesPanel = DeprecationIssuesPanel;