"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResolutionTableCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  manualCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.manualCellLabel', {
    defaultMessage: 'Manual'
  }),
  manualCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.manualCellTooltipLabel', {
    defaultMessage: 'This issue needs to be resolved manually.'
  }),
  automatedCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automatedCellLabel', {
    defaultMessage: 'Automated'
  }),
  automationInProgressCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationInProgressCellLabel', {
    defaultMessage: 'Resolution in progress…'
  }),
  automationCompleteCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationCompleteCellLabel', {
    defaultMessage: 'Resolved'
  }),
  automationFailedCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationFailedCellLabel', {
    defaultMessage: 'Resolution failed'
  }),
  automatedCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automatedCellTooltipLabel', {
    defaultMessage: 'This issue can be resolved automatically.'
  })
};
const ResolutionTableCell = ({
  deprecationId,
  isAutomated,
  deprecationResolutionState
}) => {
  if (isAutomated) {
    if ((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.id) === deprecationId) {
      const {
        resolveDeprecationStatus
      } = deprecationResolutionState;
      switch (resolveDeprecationStatus) {
        case 'in_progress':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "m"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, i18nTexts.automationInProgressCellLabel)));
        case 'fail':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "warning",
            color: "danger"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, i18nTexts.automationFailedCellLabel)));
        case 'ok':
        default:
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "check",
            color: "success"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, i18nTexts.automationCompleteCellLabel)));
      }
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: i18nTexts.automatedCellTooltipLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "resolutionStatusCell"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "indexSettings"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, i18nTexts.automatedCellLabel))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18nTexts.manualCellTooltipLabel,
    "data-test-subj": "resolutionStatusCell"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, i18nTexts.manualCellLabel));
};
exports.ResolutionTableCell = ResolutionTableCell;