"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsDeprecationsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _app_context = require("../../app_context");
var _deprecation_types = require("./deprecation_types");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  refreshButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.refreshButtonLabel', {
    defaultMessage: 'Refresh'
  }),
  noDeprecationsMessage: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.noDeprecationsMessage', {
    defaultMessage: 'No Elasticsearch deprecation issues found'
  }),
  typeFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.typeFilterLabel', {
    defaultMessage: 'Type'
  }),
  criticalFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.criticalFilterLabel', {
    defaultMessage: 'Critical'
  }),
  searchPlaceholderLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.searchPlaceholderLabel', {
    defaultMessage: 'Filter'
  })
};
const cellToLabelMap = {
  isCritical: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.statusColumnTitle', {
      defaultMessage: 'Status'
    }),
    width: '8px'
  },
  message: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.issueColumnTitle', {
      defaultMessage: 'Issue'
    }),
    width: '36px'
  },
  type: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.typeColumnTitle', {
      defaultMessage: 'Type'
    }),
    width: '10px'
  },
  index: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    width: '24px'
  },
  correctiveAction: {
    label: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.table.resolutionColumnTitle', {
      defaultMessage: 'Resolution'
    }),
    width: '24px'
  }
};
const cellTypes = Object.keys(cellToLabelMap);
const pageSizeOptions = _constants.PAGINATION_CONFIG.pageSizeOptions;
const renderTableRowCells = (deprecation, mlUpgradeModeEnabled) => {
  var _deprecation$correcti;
  switch ((_deprecation$correcti = deprecation.correctiveAction) === null || _deprecation$correcti === void 0 ? void 0 : _deprecation$correcti.type) {
    case 'mlSnapshot':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.MlSnapshotsTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes,
        mlUpgradeModeEnabled: mlUpgradeModeEnabled
      });
    case 'indexSetting':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.IndexSettingsTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes
      });
    case 'clusterSetting':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.ClusterSettingsTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes
      });
    case 'reindex':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.ReindexTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes
      });
    case 'healthIndicator':
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.HealthIndicatorTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_deprecation_types.DefaultTableRow, {
        deprecation: deprecation,
        rowFieldNames: cellTypes
      });
  }
};
const getSortedItems = (deprecations, sortConfig) => {
  const {
    isSortAscending,
    sortField
  } = sortConfig;
  const sorted = (0, _lodash.sortBy)(deprecations, [deprecation => {
    if (sortField === 'isCritical') {
      // Critical deprecations should take precendence in ascending order
      return deprecation.isCritical !== true;
    }
    return deprecation[sortField];
  }]);
  return isSortAscending ? sorted : sorted.reverse();
};
const EsDeprecationsTable = ({
  deprecations = [],
  reload
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    data
  } = api.useLoadMlUpgradeMode();
  const mlUpgradeModeEnabled = !!(data !== null && data !== void 0 && data.mlUpgradeModeEnabled);
  const [sortConfig, setSortConfig] = (0, _react.useState)({
    isSortAscending: true,
    sortField: 'isCritical'
  });
  const [itemsPerPage, setItemsPerPage] = (0, _react.useState)(_constants.PAGINATION_CONFIG.initialPageSize);
  const [currentPageIndex, setCurrentPageIndex] = (0, _react.useState)(0);
  const [searchQuery, setSearchQuery] = (0, _react.useState)(_eui.EuiSearchBar.Query.MATCH_ALL);
  const [searchError, setSearchError] = (0, _react.useState)(undefined);
  const [filteredDeprecations, setFilteredDeprecations] = (0, _react.useState)(getSortedItems(deprecations, sortConfig));
  const pager = (0, _react.useMemo)(() => new _eui.Pager(deprecations.length, itemsPerPage, currentPageIndex), [currentPageIndex, deprecations, itemsPerPage]);
  const visibleDeprecations = (0, _react.useMemo)(() => filteredDeprecations.slice(pager.firstItemIndex, pager.lastItemIndex + 1), [filteredDeprecations, pager]);
  const handleSort = (0, _react.useCallback)(fieldName => {
    const newSortConfig = {
      isSortAscending: sortConfig.sortField === fieldName ? !sortConfig.isSortAscending : true,
      sortField: fieldName
    };
    setSortConfig(newSortConfig);
  }, [sortConfig]);
  const handleSearch = (0, _react.useCallback)(({
    query,
    error
  }) => {
    if (error) {
      setSearchError(error);
    } else {
      setSearchError(undefined);
      setSearchQuery(query);
    }
  }, []);
  (0, _react.useEffect)(() => {
    const {
      setTotalItems,
      goToPageIndex
    } = pager;
    const deprecationsFilteredByQuery = _eui.EuiSearchBar.Query.execute(searchQuery, deprecations);
    const deprecationsSortedByFieldType = getSortedItems(deprecationsFilteredByQuery, sortConfig);
    setTotalItems(deprecationsSortedByFieldType.length);
    setFilteredDeprecations(deprecationsSortedByFieldType);

    // Reset pagination if the filtered results return a different length
    if (deprecationsSortedByFieldType.length !== filteredDeprecations.length) {
      goToPageIndex(0);
    }
  }, [deprecations, sortConfig, pager, searchQuery, filteredDeprecations.length]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "searchBarContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      placeholder: i18nTexts.searchPlaceholderLabel,
      incremental: true
    },
    filters: [{
      type: 'is',
      field: 'isCritical',
      name: i18nTexts.criticalFilterLabel
    }, {
      type: 'field_value_selection',
      field: 'type',
      name: i18nTexts.typeFilterLabel,
      multiSelect: false,
      options: Object.keys(_constants.DEPRECATION_TYPE_MAP).map(type => ({
        value: type,
        name: _constants.DEPRECATION_TYPE_MAP[type]
      }))
    }],
    onChange: handleSearch
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: reload,
    "data-test-subj": "refreshButton",
    key: "refreshButton"
  }, i18nTexts.refreshButtonLabel))), searchError && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "invalidSearchQueryMessage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "danger",
    title: `Invalid search: ${searchError.message}`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    "data-test-subj": "esDeprecationsTable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, Object.entries(cellToLabelMap).map(([fieldName, cell]) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
      width: cell.width,
      key: cell.label,
      onSort: () => handleSort(fieldName),
      isSorted: sortConfig.sortField === fieldName,
      isSortAscending: sortConfig.isSortAscending
    }, cell.label);
  })), filteredDeprecations.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    "data-test-subj": "noDeprecationsRow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "center",
    colSpan: cellTypes.length,
    mobileOptions: {
      width: '100%'
    }
  }, i18nTexts.noDeprecationsMessage))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, visibleDeprecations.map((deprecation, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
      "data-test-subj": "deprecationTableRow",
      key: `deprecation-row-${index}`
    }, renderTableRowCells(deprecation, mlUpgradeModeEnabled));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "data-test-subj": "esDeprecationsPagination",
    activePage: pager.getCurrentPageIndex(),
    itemsPerPage: pager.itemsPerPage,
    itemsPerPageOptions: pageSizeOptions,
    pageCount: pager.getTotalPages(),
    onChangeItemsPerPage: setItemsPerPage,
    onChangePage: setCurrentPageIndex
  }));
};
exports.EsDeprecationsTable = EsDeprecationsTable;