"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepProgress = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./_step_progress.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepStatus = ({
  status,
  idx
}) => {
  if (status === 'incomplete') {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "upgStepProgress__status"
    }, idx + 1, ".");
  } else if (status === 'inProgress') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      className: "upgStepProgress__status"
    });
  } else if (status === 'complete') {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "upgStepProgress__status upgStepProgress__status--circle upgStepProgress__status--circle-complete"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      size: "s"
    }));
  } else if (status === 'paused') {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "upgStepProgress__status upgStepProgress__status--circle upgStepProgress__status--circle-paused"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pause",
      size: "s"
    }));
  } else if (status === 'cancelled') {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "upgStepProgress__status upgStepProgress__status--circle upgStepProgress__status--circle-cancelled"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      size: "s"
    }));
  } else if (status === 'failed') {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "upgStepProgress__status upgStepProgress__status--circle upgStepProgress__status--circle-failed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      size: "s"
    }));
  }
  throw new Error(`Unsupported status: ${status}`);
};
const Step = ({
  title,
  status,
  children,
  idx
}) => {
  const titleClassName = (0, _classnames.default)('upgStepProgress__title', {
    'upgStepProgress__title--currentStep': status === 'inProgress'
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "upgStepProgress__step"
  }, /*#__PURE__*/_react.default.createElement(StepStatus, {
    status: status,
    idx: idx
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: titleClassName
  }, title)), children && /*#__PURE__*/_react.default.createElement("div", {
    className: "upgStepProgress__content"
  }, children));
};
/**
 * A generic component that displays a series of automated steps and the system's progress.
 */
const StepProgress = ({
  steps
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "upgStepProgress__container"
  }, steps.map((step, idx) => /*#__PURE__*/_react.default.createElement(Step, (0, _extends2.default)({
    key: idx
  }, step, {
    idx: idx
  }))));
};
exports.StepProgress = StepProgress;