"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReindexContext = exports.ReindexStatusProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_reindex_state = require("./use_reindex_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReindexContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useReindexContext = () => {
  const context = (0, _react.useContext)(ReindexContext);
  if (context === undefined) {
    throw new Error('useReindexContext must be used within a <ReindexStatusProvider />');
  }
  return context;
};
exports.useReindexContext = useReindexContext;
const ReindexStatusProvider = ({
  api,
  indexName,
  children
}) => {
  const {
    reindexState,
    startReindex,
    cancelReindex
  } = (0, _use_reindex_state.useReindexStatus)({
    indexName,
    api
  });
  return /*#__PURE__*/_react.default.createElement(ReindexContext.Provider, {
    value: {
      reindexState,
      startReindex,
      cancelReindex
    }
  }, children);
};
exports.ReindexStatusProvider = ReindexStatusProvider;