"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlSnapshotsTableRowCells = exports.MlSnapshotsTableRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _app_context = require("../../../../app_context");
var _es_deprecations_table_cells = require("../../es_deprecations_table_cells");
var _resolution_table_cell = require("./resolution_table_cell");
var _flyout = require("./flyout");
var _context = require("./context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const MlSnapshotsTableRowCells = ({
  rowFieldNames,
  deprecation
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const snapshotState = (0, _context.useMlSnapshotContext)();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    removeContentFromGlobalFlyout('mlFlyout');
  }, [removeContentFromGlobalFlyout]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: 'mlFlyout',
        Component: _flyout.FixSnapshotsFlyout,
        props: {
          deprecation,
          closeFlyout,
          ...snapshotState
        },
        flyoutProps: {
          onClose: closeFlyout,
          className: 'eui-textBreakWord',
          'data-test-subj': 'mlSnapshotDetails',
          'aria-labelledby': 'mlSnapshotDetailsFlyoutTitle'
        }
      });
    }
  }, [snapshotState, addContentToGlobalFlyout, showFlyout, deprecation, closeFlyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rowFieldNames.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: field,
      truncateText: false,
      "data-test-subj": `mlTableCell-${field}`
    }, /*#__PURE__*/_react.default.createElement(_es_deprecations_table_cells.EsDeprecationsTableCells, {
      fieldName: field,
      openFlyout: () => setShowFlyout(true),
      deprecation: deprecation,
      resolutionTableCell: /*#__PURE__*/_react.default.createElement(_resolution_table_cell.MlSnapshotsResolutionCell, null)
    }));
  }));
};
exports.MlSnapshotsTableRowCells = MlSnapshotsTableRowCells;
const MlSnapshotsTableRow = props => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  return /*#__PURE__*/_react.default.createElement(_context.MlSnapshotsStatusProvider, {
    snapshotId: props.deprecation.correctiveAction.snapshotId,
    jobId: props.deprecation.correctiveAction.jobId,
    mlUpgradeModeEnabled: props.mlUpgradeModeEnabled,
    api: api
  }, /*#__PURE__*/_react.default.createElement(MlSnapshotsTableRowCells, props));
};
exports.MlSnapshotsTableRow = MlSnapshotsTableRow;