"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FixDeprecationLogs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../app_context");
var _external_links = require("./external_links");
var _deprecations_count_checkpoint = require("./deprecations_count_checkpoint");
var _use_deprecation_logging = require("./use_deprecation_logging");
var _deprecation_logging_toggle = require("./deprecation_logging_toggle");
var _logs_checkpoint = require("../../../lib/logs_checkpoint");
var _constants = require("../../../../../common/constants");
var _shared_imports = require("../../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  analyzeTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.analyzeTitle', {
    defaultMessage: 'Analyze deprecation logs'
  }),
  deprecationsCountCheckpointTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationsCountCheckpointTitle', {
    defaultMessage: 'Resolve deprecation issues and verify your changes'
  }),
  apiCompatibilityNoteTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.apiCompatibilityNoteTitle', {
    defaultMessage: 'Apply API compatibility headers (optional)'
  }),
  apiCompatibilityNoteBody: docLink => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.overview.apiCompatibilityNoteBody",
    defaultMessage: "We recommend you resolve all deprecation issues before upgrading. If needed, you can apply API compatibility headers to requests that use deprecated features. {learnMoreLink}.",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.overview.apiCompatibilityNoteLink",
        defaultMessage: "Learn more"
      }))
    }
  }),
  onlyLogWritingEnabledTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.deprecationWarningTitle', {
    defaultMessage: 'Your logs are being written to the logs directory'
  }),
  onlyLogWritingEnabledBody: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.deprecationWarningBody', {
    defaultMessage: 'Go to your logs directory to view the deprecation logs or enable deprecation log collection to see them in Kibana.'
  }),
  deniedPrivilegeTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.deprecationLogs.deniedPrivilegeTitle', {
    defaultMessage: 'You require index privileges to analyze the deprecation logs'
  }),
  deniedPrivilegeDescription: privilegesMissing => {
    var _privilegesMissing$in, _privilegesMissing$in2;
    return (
      /*#__PURE__*/
      // NOTE: hardcoding the missing privilege because the WithPrivileges HOC
      // doesnt provide a way to retrieve which specific privileges an index
      // is missing.
      _react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.overview.deprecationLogs.deniedPrivilegeDescription",
        defaultMessage: "The deprecation logs will continue to be indexed, but you won't be able to analyze them until you have the read index {privilegesCount, plural, one {privilege} other {privileges}} for: {missingPrivileges}",
        values: {
          missingPrivileges: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            transparentBackground: true
          }, privilegesMissing === null || privilegesMissing === void 0 ? void 0 : (_privilegesMissing$in = privilegesMissing.index) === null || _privilegesMissing$in === void 0 ? void 0 : _privilegesMissing$in.join(', ')),
          privilegesCount: privilegesMissing === null || privilegesMissing === void 0 ? void 0 : (_privilegesMissing$in2 = privilegesMissing.index) === null || _privilegesMissing$in2 === void 0 ? void 0 : _privilegesMissing$in2.length
        }
      })
    );
  }
};
const FixDeprecationLogsUI = ({
  hasPrivileges,
  privilegesMissing
}) => {
  const {
    services: {
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    isDeprecationLogIndexingEnabled,
    onlyDeprecationLogWritingEnabled,
    isLoading,
    isUpdating,
    fetchError,
    updateError,
    resendRequest,
    toggleLogging
  } = (0, _use_deprecation_logging.useDeprecationLogging)();
  const [checkpoint, setCheckpoint] = (0, _react.useState)((0, _logs_checkpoint.loadLogsCheckpoint)());
  (0, _react.useEffect)(() => {
    (0, _logs_checkpoint.saveLogsCheckpoint)(checkpoint);
  }, [checkpoint]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_deprecation_logging_toggle.DeprecationLoggingToggle, {
    isDeprecationLogIndexingEnabled: isDeprecationLogIndexingEnabled,
    isLoading: isLoading,
    isUpdating: isUpdating,
    fetchError: fetchError,
    updateError: updateError,
    resendRequest: resendRequest,
    toggleLogging: toggleLogging
  }), onlyDeprecationLogWritingEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.onlyLogWritingEnabledTitle,
    color: "warning",
    iconType: "help",
    "data-test-subj": "deprecationWarningCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.onlyLogWritingEnabledBody))), !hasPrivileges && isDeprecationLogIndexingEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "help",
    color: "warning",
    title: i18nTexts.deniedPrivilegeTitle,
    "data-test-subj": "noIndexPermissionsCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.deniedPrivilegeDescription(privilegesMissing)))), hasPrivileges && isDeprecationLogIndexingEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "externalLinksTitle"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18nTexts.analyzeTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_external_links.ExternalLinks, {
    checkpoint: checkpoint
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "deprecationsCountTitle"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18nTexts.deprecationsCountCheckpointTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_deprecations_count_checkpoint.DeprecationsCountCheckpoint, {
    checkpoint: checkpoint,
    setCheckpoint: setCheckpoint
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "apiCompatibilityNoteTitle"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18nTexts.apiCompatibilityNoteTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.apiCompatibilityNoteBody(docLinks.links.elasticsearch.apiCompatibilityHeader)))));
};
const FixDeprecationLogs = () => {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: `index.${_constants.DEPRECATION_LOGS_INDEX}`
  }, ({
    hasPrivileges,
    privilegesMissing,
    isLoading
  }) => /*#__PURE__*/_react.default.createElement(FixDeprecationLogsUI, {
    hasPrivileges: !isLoading && hasPrivileges,
    privilegesMissing: privilegesMissing
  }));
};
exports.FixDeprecationLogs = FixDeprecationLogs;