"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationsCountCheckpoint = void 0;
var _react = _interopRequireWildcard(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _ui_metric = require("../../../../lib/ui_metric");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  calloutTitle: (warningsCount, previousCheck) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.overview.verifyChanges.calloutTitle",
    defaultMessage: "{warningsCount, plural, =0 {No} other {{warningsCount}}} deprecation {warningsCount, plural, one {issue} other {issues}} since {previousCheck}",
    values: {
      warningsCount,
      previousCheck: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: previousCheck,
        year: "numeric",
        month: "long",
        day: "2-digit"
      }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: previousCheck,
        timeZoneName: "short",
        hour12: false
      }))
    }
  }),
  calloutBody: _i18n.i18n.translate('xpack.upgradeAssistant.overview.verifyChanges.calloutBody', {
    defaultMessage: `After making changes, reset the counter and continue monitoring to verify you're no longer using deprecated features.`
  }),
  loadingError: _i18n.i18n.translate('xpack.upgradeAssistant.overview.verifyChanges.loadingError', {
    defaultMessage: 'An error occurred while retrieving the count of deprecation logs'
  }),
  retryButton: _i18n.i18n.translate('xpack.upgradeAssistant.overview.verifyChanges.retryButton', {
    defaultMessage: 'Try again'
  }),
  resetCounterButton: _i18n.i18n.translate('xpack.upgradeAssistant.overview.verifyChanges.resetCounterButton', {
    defaultMessage: 'Reset counter'
  }),
  errorToastTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.verifyChanges.errorToastTitle', {
    defaultMessage: 'Could not delete deprecation logs cache'
  })
};
const DeprecationsCountCheckpoint = ({
  checkpoint,
  setCheckpoint
}) => {
  const [isDeletingCache, setIsDeletingCache] = (0, _react.useState)(false);
  const {
    services: {
      api,
      core: {
        notifications
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    data,
    error,
    isLoading,
    resendRequest,
    isInitialRequest
  } = api.getDeprecationLogsCount(checkpoint);
  const logsCount = (data === null || data === void 0 ? void 0 : data.count) || 0;
  const hasLogs = logsCount > 0;
  const calloutTint = hasLogs ? 'warning' : 'success';
  const calloutIcon = hasLogs ? 'warning' : 'check';
  const calloutTestId = hasLogs ? 'hasWarningsCallout' : 'noWarningsCallout';
  const onResetClick = async () => {
    setIsDeletingCache(true);
    const {
      error: deleteLogsCacheError
    } = await api.deleteDeprecationLogsCache();
    setIsDeletingCache(false);
    if (deleteLogsCacheError) {
      notifications.toasts.addDanger({
        title: i18nTexts.errorToastTitle,
        text: deleteLogsCacheError.message.toString()
      });
      return;
    }
    const now = (0, _momentTimezone.default)().toISOString();
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_RESET_LOGS_COUNTER_CLICK);
    setCheckpoint(now);
  };
  if (isInitialRequest && isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 6
    });
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18nTexts.loadingError,
      color: "danger",
      iconType: "warning",
      "data-test-subj": "errorCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, error.statusCode, " - ", error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: resendRequest,
      "data-test-subj": "retryButton"
    }, i18nTexts.retryButton));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.calloutTitle(logsCount, checkpoint),
    color: calloutTint,
    iconType: calloutIcon,
    "data-test-subj": calloutTestId
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.calloutBody), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: calloutTint,
    onClick: onResetClick,
    isLoading: isDeletingCache || isLoading,
    "data-test-subj": "resetLastStoredDate"
  }, i18nTexts.resetCounterButton));
};
exports.DeprecationsCountCheckpoint = DeprecationsCountCheckpoint;