"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsDeprecationLogs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _i18nReact = require("@kbn/i18n-react");
var _app_context = require("../../app_context");
var _ui_metric = require("../../lib/ui_metric");
var _fix_deprecation_logs = require("./fix_deprecation_logs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EsDeprecationLogs = () => {
  const {
    services: {
      breadcrumbs,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  (0, _react.useEffect)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.LOADED, _ui_metric.UIM_ES_DEPRECATION_LOGS_PAGE_LOAD);
  }, []);
  (0, _react.useEffect)(() => {
    breadcrumbs.setBreadcrumbs('esDeprecationLogs');
  }, [breadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: true,
    "data-test-subj": "esDeprecationLogs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    color: "transparent",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecationLogs.pageTitle', {
      defaultMessage: 'Elasticsearch deprecation logs'
    }),
    description: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecationLogs.pageDescription', {
      defaultMessage: 'Review the deprecation logs to determine if your applications are using any deprecated APIs. Update your applications to prevent errors or changes in behavior after you upgrade.'
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: docLinks.links.elasticsearch.migrationApiDeprecation,
      target: "_blank",
      iconType: "help",
      "data-test-subj": "documentationLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecationLogs.documentationLinkText",
      defaultMessage: "Documentation"
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_fix_deprecation_logs.FixDeprecationLogs, null)));
};
exports.EsDeprecationLogs = EsDeprecationLogs;