"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGINATION_CONFIG = exports.DEPRECATION_TYPE_MAP = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEPRECATION_TYPE_MAP = exports.DEPRECATION_TYPE_MAP = {
  cluster_settings: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.clusterDeprecationTypeLabel', {
    defaultMessage: 'Cluster'
  }),
  index_settings: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indexDeprecationTypeLabel', {
    defaultMessage: 'Index'
  }),
  node_settings: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.nodeDeprecationTypeLabel', {
    defaultMessage: 'Node'
  }),
  ml_settings: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlDeprecationTypeLabel', {
    defaultMessage: 'Machine Learning'
  }),
  health_indicator: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.healthIndicatorTypeLabel', {
    defaultMessage: 'Health Indicator'
  })
};
const PAGINATION_CONFIG = exports.PAGINATION_CONFIG = {
  initialPageSize: 50,
  pageSizeOptions: [50, 100, 200]
};