"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterBadgeLazy = exports.FilterBadgeGroupLazy = exports.FilterBadgeGroup = exports.FilterBadge = void 0;
Object.defineProperty(exports, "FilterContent", {
  enumerable: true,
  get: function () {
    return _filter_content.FilterContent;
  }
});
Object.defineProperty(exports, "FilterContentLazy", {
  enumerable: true,
  get: function () {
    return _filter_content.FilterContentLazy;
  }
});
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _filter_content = require("./filter_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * The Lazily-loaded `FilterBadge` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const FilterBadgeLazy = exports.FilterBadgeLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./filter_badge'))));

/**
 * A `FilterBadge` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `FilterBadgeLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const FilterBadge = exports.FilterBadge = (0, _sharedUxUtility.withSuspense)(FilterBadgeLazy);

/**
 * The Lazily-loaded `FilterBadgeGroup` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const FilterBadgeGroupLazy = exports.FilterBadgeGroupLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./filter_badge_group'))));

/**
 * A `FilterBadgeGroup` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `FilterBadgeGroupLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const FilterBadgeGroup = exports.FilterBadgeGroup = (0, _sharedUxUtility.withSuspense)(FilterBadgeGroupLazy);