"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.marginLeftLabelCss = exports.conditionSpacesCss = exports.conditionCss = exports.bracketColorCss = exports.badgePaddingCss = void 0;
var _css = require("@emotion/css");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const badgePaddingCss = euiTheme => (0, _css.css)`
  padding: calc(${euiTheme.size.xs} + ${euiTheme.size.xxs});
`;
exports.badgePaddingCss = badgePaddingCss;
const marginLeftLabelCss = euiTheme => (0, _css.css)`
  margin-left: ${euiTheme.size.xs};
`;
exports.marginLeftLabelCss = marginLeftLabelCss;
const bracketColorCss = exports.bracketColorCss = (0, _css.css)`
  color: ${_uiTheme.euiThemeVars.euiColorPrimary};
`;
const conditionSpacesCss = euiTheme => (0, _css.css)`
  margin-inline: -${euiTheme.size.xs};
`;
exports.conditionSpacesCss = conditionSpacesCss;
const conditionCss = exports.conditionCss = (0, _css.css)`
  ${bracketColorCss}
`;