"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsList = DataViewsList;
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _dataViewUtils = require("@kbn/data-view-utils");
var _sorting_service = require("./sorting_service");
var _helpers = require("../filter_bar/filter_editor/lib/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  sortOrder: {
    asc: {
      getSortOrderLabel: () => _i18n.i18n.translate('unifiedSearch.optionsList.popover.sortOrder.asc', {
        defaultMessage: 'Ascending'
      })
    },
    desc: {
      getSortOrderLabel: () => _i18n.i18n.translate('unifiedSearch.optionsList.popover.sortOrder.desc', {
        defaultMessage: 'Descending'
      })
    }
  },
  editorAndPopover: {
    getSortDirectionLegend: () => _i18n.i18n.translate('unifiedSearch.optionsList.popover.sortDirections', {
      defaultMessage: 'Sort directions'
    }),
    adhoc: {
      getTemporaryDataviewLabel: () => _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.temporaryDataviewLabel', {
        defaultMessage: 'Temporary'
      })
    },
    search: {
      getSearchPlaceholder: () => _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.findDataView', {
        defaultMessage: 'Find a data view'
      })
    }
  }
};
function DataViewsList({
  dataViewsList,
  onChangeDataView,
  isTextBasedLangSelected,
  currentDataViewId,
  selectableProps,
  searchListInputId
}) {
  const sortingService = (0, _react.useMemo)(() => new _sorting_service.SortingService({
    alphabetically: item => {
      var _item$name;
      return (_item$name = item.name) !== null && _item$name !== void 0 ? _item$name : item.title;
    }
  }), []);
  const [sortedDataViewsList, setSortedDataViewsList] = (0, _react.useState)(() => {
    // Don't show ES|QL ad hoc data views in the data view list
    const filteredDataViewsList = dataViewsList.filter(dataView => !dataView.isAdhoc || dataView.type !== _dataViewUtils.ESQL_TYPE);
    return sortingService.sortData(filteredDataViewsList);
  });
  const sortOrderOptions = (0, _react.useMemo)(() => sortingService.getOrderDirections().map(key => {
    return {
      id: key,
      iconType: `sort${(0, _eui.toSentenceCase)(key)}ending`,
      label: strings.sortOrder[key].getSortOrderLabel()
    };
  }), [sortingService]);
  const onChangeSortDirection = (0, _react.useCallback)(value => {
    sortingService.setDirection(value);
    setSortedDataViewsList(dataViews => sortingService.sortData(dataViews));
  }, [sortingService]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, (0, _extends2.default)({}, selectableProps, {
    listProps: {
      truncationProps: _helpers.MIDDLE_TRUNCATION_PROPS,
      ...(selectableProps !== null && selectableProps !== void 0 && selectableProps.listProps ? selectableProps.listProps : undefined)
    },
    "data-test-subj": "indexPattern-switcher",
    searchable: true,
    singleSelection: "always",
    options: sortedDataViewsList === null || sortedDataViewsList === void 0 ? void 0 : sortedDataViewsList.map(({
      title,
      id,
      name,
      isAdhoc
    }) => ({
      key: id,
      label: name ? name : title,
      value: id,
      checked: id === currentDataViewId && !Boolean(isTextBasedLangSelected) ? 'on' : undefined,
      append: isAdhoc ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": `dataViewItemTempBadge-${name}`
      }, strings.editorAndPopover.adhoc.getTemporaryDataviewLabel()) : null
    })),
    onChange: choices => {
      const choice = choices.find(({
        checked
      }) => checked);
      onChangeDataView(choice.value);
    },
    searchProps: {
      id: searchListInputId,
      compressed: true,
      placeholder: strings.editorAndPopover.search.getSearchPlaceholder(),
      'data-test-subj': 'indexPattern-switcher--input',
      ...(selectableProps ? selectableProps.searchProps : undefined)
    }
  }), (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
              padding-bottom: 0;
            `,
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, search), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isIconOnly: true,
    buttonSize: "compressed",
    options: sortOrderOptions,
    legend: strings.editorAndPopover.getSortDirectionLegend(),
    idSelected: sortingService.direction,
    onChange: onChangeSortDirection
  })))), list));
}

// React.lazy support
// eslint-disable-next-line import/no-default-export
var _default = exports.default = DataViewsList;