"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DataViewSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _dataview_list = require("./dataview_list");
var _explore_matching_button = require("./explore_matching_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DataViewSelector = ({
  currentDataViewId,
  searchListInputId,
  dataViewsList,
  selectableProps,
  isTextBasedLangSelected,
  setPopoverIsOpen,
  onChangeDataView,
  onCreateDefaultAdHocDataView
}) => {
  const kibana = (0, _public.useKibana)();
  const {
    dataViews
  } = kibana.services;
  const [noDataViewMatches, setNoDataViewMatches] = (0, _react.useState)(false);
  const [dataViewSearchString, setDataViewSearchString] = (0, _react.useState)('');
  const [indexMatches, setIndexMatches] = (0, _react.useState)(0);
  const pendingIndexMatch = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    async function checkIndices() {
      if (dataViewSearchString !== '' && noDataViewMatches) {
        const matches = await dataViews.getIndices({
          pattern: dataViewSearchString,
          isRollupIndex: () => false,
          showAllIndices: false
        });
        setIndexMatches(matches.length);
      }
    }
    pendingIndexMatch.current = setTimeout(checkIndices, 250);
    return () => {
      if (pendingIndexMatch.current) {
        clearTimeout(pendingIndexMatch.current);
      }
    };
  }, [dataViewSearchString, dataViews, noDataViewMatches]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_dataview_list.DataViewsList, {
    dataViewsList: dataViewsList,
    onChangeDataView: onChangeDataView,
    currentDataViewId: currentDataViewId,
    selectableProps: {
      ...(selectableProps || {}),
      // @ts-expect-error Some EUI weirdness
      searchProps: {
        ...((selectableProps === null || selectableProps === void 0 ? void 0 : selectableProps.searchProps) || {}),
        onChange: (value, matches) => {
          var _selectableProps$sear, _selectableProps$sear2;
          selectableProps === null || selectableProps === void 0 ? void 0 : (_selectableProps$sear = selectableProps.searchProps) === null || _selectableProps$sear === void 0 ? void 0 : (_selectableProps$sear2 = _selectableProps$sear.onChange) === null || _selectableProps$sear2 === void 0 ? void 0 : _selectableProps$sear2.call(_selectableProps$sear, value, matches);
          setNoDataViewMatches(matches.length === 0 && dataViewsList.length > 0);
          setDataViewSearchString(value);
        }
      }
    },
    searchListInputId: searchListInputId,
    isTextBasedLangSelected: isTextBasedLangSelected
  }), /*#__PURE__*/_react.default.createElement(_explore_matching_button.ExploreMatchingButton, {
    noDataViewMatches: noDataViewMatches,
    indexMatches: indexMatches,
    dataViewSearchString: dataViewSearchString,
    setPopoverIsOpen: setPopoverIsOpen,
    onCreateDefaultAdHocDataView: onCreateDefaultAdHocDataView
  }));
};

// React.lazy support
// eslint-disable-next-line import/no-default-export
exports.DataViewSelector = DataViewSelector;
var _default = exports.default = DataViewSelector;