"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.changeDataViewStyles = void 0;
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MIN_WIDTH = 300;
const changeDataViewStyles = ({
  fullWidth,
  dataViewsList
}) => {
  return {
    trigger: {
      maxWidth: fullWidth ? undefined : MIN_WIDTH
    },
    popoverContent: {
      width: (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(dataViewsList, ['name', 'id'], {
        minWidth: MIN_WIDTH
      })
    }
  };
};
exports.changeDataViewStyles = changeDataViewStyles;