"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupKqlQuerySuggestionProvider = exports.KUERY_LANGUAGE_NAME = void 0;
var _lodash = require("lodash");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const cursorSymbol = '@kuery-cursor@';
const dedup = suggestions => (0, _lodash.uniqBy)(suggestions, ({
  type,
  text,
  start,
  end
}) => [type, text, start, end].join('|'));
const KUERY_LANGUAGE_NAME = exports.KUERY_LANGUAGE_NAME = 'kuery';
const setupKqlQuerySuggestionProvider = core => {
  let getSuggestionsByType;
  const asyncGetSuggestionsByTypeFn = async () => {
    if (getSuggestionsByType) {
      return getSuggestionsByType;
    }
    const {
      setupGetFieldSuggestions,
      setupGetValueSuggestions,
      setupGetOperatorSuggestions,
      setupGetConjunctionSuggestions
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_loads')));
    const {
      fromKueryExpression
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
    const providers = {
      field: setupGetFieldSuggestions(core),
      value: setupGetValueSuggestions(core),
      operator: setupGetOperatorSuggestions(core),
      conjunction: setupGetConjunctionSuggestions(core)
    };
    return getSuggestionsByType = async (cursoredQuery, querySuggestionsArgs) => {
      try {
        const {
          suggestionsAbstraction
        } = querySuggestionsArgs;
        let cursorNode = fromKueryExpression(cursoredQuery, {
          cursorSymbol,
          parseCursor: true
        });
        const isNested = cursorNode.nestedPath && cursorNode.nestedPath.length > 0;
        const fieldName = isNested ? `${cursorNode.nestedPath}.${cursorNode.fieldName}` : cursorNode.fieldName;
        if (suggestionsAbstraction && suggestionsAbstraction !== null && suggestionsAbstraction !== void 0 && suggestionsAbstraction.fields[fieldName]) {
          if (isNested) {
            var _suggestionsAbstracti, _suggestionsAbstracti2, _suggestionsAbstracti3, _suggestionsAbstracti4;
            cursorNode = {
              ...cursorNode,
              fieldName: (_suggestionsAbstracti = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : (_suggestionsAbstracti2 = suggestionsAbstraction.fields[fieldName]) === null || _suggestionsAbstracti2 === void 0 ? void 0 : _suggestionsAbstracti2.nestedField) !== null && _suggestionsAbstracti !== void 0 ? _suggestionsAbstracti : fieldName,
              nestedPath: (_suggestionsAbstracti3 = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : (_suggestionsAbstracti4 = suggestionsAbstraction.fields[fieldName]) === null || _suggestionsAbstracti4 === void 0 ? void 0 : _suggestionsAbstracti4.nestedPath) !== null && _suggestionsAbstracti3 !== void 0 ? _suggestionsAbstracti3 : fieldName
            };
          } else {
            var _suggestionsAbstracti5, _suggestionsAbstracti6;
            cursorNode = {
              ...cursorNode,
              fieldName: (_suggestionsAbstracti5 = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : (_suggestionsAbstracti6 = suggestionsAbstraction.fields[fieldName]) === null || _suggestionsAbstracti6 === void 0 ? void 0 : _suggestionsAbstracti6.field) !== null && _suggestionsAbstracti5 !== void 0 ? _suggestionsAbstracti5 : fieldName
            };
          }
        }
        return cursorNode.suggestionTypes.map(type => providers[type](querySuggestionsArgs, cursorNode));
      } catch (e) {
        return [];
      }
    };
  };
  return async querySuggestionsArgs => {
    const {
      query,
      selectionStart,
      selectionEnd
    } = querySuggestionsArgs;
    const cursoredQuery = `${query.substr(0, selectionStart)}${cursorSymbol}${query.substr(selectionEnd)}`;
    const fn = await asyncGetSuggestionsByTypeFn();
    return Promise.all(await fn(cursoredQuery, querySuggestionsArgs)).then(suggestionsByType => dedup((0, _lodash.flatten)(suggestionsByType)));
  };
};
exports.setupKqlQuerySuggestionProvider = setupKqlQuerySuggestionProvider;