"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUsageCollector = void 0;
var _rxjs = require("rxjs");
var _analytics = require("@kbn/analytics");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createUsageCollector = (getStartServices, usageCollection) => {
  const getCurrentApp = async () => {
    const [{
      application
    }] = await getStartServices();
    return application.currentAppId$.pipe((0, _rxjs.first)()).toPromise();
  };
  return {
    trackCall: async () => {
      const currentApp = await getCurrentApp();
      return usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(currentApp, _analytics.METRIC_TYPE.LOADED, _types.AUTOCOMPLETE_EVENT_TYPE.CALL);
    },
    trackRequest: async () => {
      const currentApp = await getCurrentApp();
      return usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(currentApp, _analytics.METRIC_TYPE.LOADED, _types.AUTOCOMPLETE_EVENT_TYPE.REQUEST);
    },
    trackResult: async () => {
      const currentApp = await getCurrentApp();
      return usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(currentApp, _analytics.METRIC_TYPE.LOADED, _types.AUTOCOMPLETE_EVENT_TYPE.RESULT);
    },
    trackError: async () => {
      const currentApp = await getCurrentApp();
      return usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(currentApp, _analytics.METRIC_TYPE.LOADED, _types.AUTOCOMPLETE_EVENT_TYPE.ERROR);
    }
  };
};
exports.createUsageCollector = createUsageCollector;